/*
 * Decompiled with CFR 0.152.
 */
package jme.geometry.primitive;

import java.util.logging.Level;
import jme.exception.MonkeyRuntimeException;
import jme.geometry.primitive.Quadric;
import jme.math.Vector;
import jme.utility.LoggingSystem;

public class Disk
extends Quadric {
    protected double innerRadius;
    protected double outerRadius;
    protected int slices;
    protected int loops;

    public Disk(double d, double d2, int n, int n2) {
        if (d < 0.0 || d2 <= 0.0 || n <= 0 || n2 <= 0) {
            throw new MonkeyRuntimeException("No disk value may be less than zero, and only innerRadius may be zero");
        }
        this.innerRadius = d;
        this.outerRadius = d2;
        this.slices = n;
        this.loops = n2;
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Disk created.");
    }

    public void render() {
        super.preRender();
        super.clean();
    }

    public void setInnerRadius(double d) {
        if (d < 0.0) {
            throw new MonkeyRuntimeException("Inner Radius must be zero or greater");
        }
        this.innerRadius = d;
    }

    public void setOuterRadius(double d) {
        if (d <= 0.0) {
            throw new MonkeyRuntimeException("Outer Radius must be greater than zero");
        }
        this.outerRadius = d;
    }

    public void setSlices(int n) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("Slices must be greater than zero");
        }
        this.slices = n;
    }

    public void setLoops(int n) {
        if (n <= 0) {
            throw new MonkeyRuntimeException("Loops must be greater than zero");
        }
        this.loops = n;
    }

    public Vector[] getPoints() {
        return null;
    }
}

