/*
 * Decompiled with CFR 0.152.
 */
package jme.world;

import java.util.ArrayList;
import java.util.logging.Level;
import jme.entity.EntityInterface;
import jme.entity.camera.Camera;
import jme.entity.effects.ParticleSystem;
import jme.exception.MonkeyRuntimeException;
import jme.locale.Locale;
import jme.locale.external.feature.Water;
import jme.utility.LoggingSystem;
import org.lwjgl.opengl.GL;

public class World {
    private GL gl;
    private Locale locale;
    private ArrayList entityList;
    private Camera camera;
    private boolean checkEntityVisibility = false;
    private int numRenderedEntities = 0;
    private int totalEntities = 0;
    private Water water;

    public World() {
        this.entityList = new ArrayList();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created World");
    }

    public World(Locale locale) {
        if (null == locale) {
            throw new MonkeyRuntimeException("Locale cannot be null");
        }
        this.locale = locale;
        this.entityList = new ArrayList();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created World");
    }

    public World(Locale locale, ArrayList arrayList) {
        if (null == locale || null == arrayList) {
            throw new MonkeyRuntimeException("Neither locale nor entities may be null");
        }
        this.locale = locale;
        this.entityList = arrayList;
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created World");
    }

    public void setLocale(Locale locale) {
        if (null == locale) {
            throw new MonkeyRuntimeException("locale may not be null");
        }
        this.locale = locale;
    }

    public void setWater(Water water) {
        this.water = water;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setEntityVisibility(boolean bl) {
        this.checkEntityVisibility = bl;
    }

    public void addEntity(EntityInterface entityInterface) {
        if (null == entityInterface) {
            throw new MonkeyRuntimeException("Entity may not be null");
        }
        this.entityList.add(entityInterface);
    }

    public int getTotalEntities() {
        return this.totalEntities;
    }

    public int getNumRenderedEntities() {
        return this.numRenderedEntities;
    }

    public void update(float f) {
        if (null != this.locale) {
            this.locale.update(f);
        }
        if (null != this.water) {
            this.water.update(f);
        }
        for (int i = 0; i < this.entityList.size(); ++i) {
            Object e = this.entityList.get(i);
            if (!(e instanceof EntityInterface)) continue;
            if (null != this.camera && this.checkEntityVisibility) {
                ((EntityInterface)e).checkVisibility(this.camera.getFrustum());
            }
            ((EntityInterface)e).update(f);
        }
    }

    public void render() {
        this.numRenderedEntities = 0;
        this.totalEntities = this.entityList.size();
        if (null != this.locale) {
            this.locale.render();
        }
        for (int i = 0; i < this.totalEntities; ++i) {
            Object e = this.entityList.get(i);
            if (!(e instanceof EntityInterface) || !((EntityInterface)this.entityList.get(i)).isVisible() && this.checkEntityVisibility) continue;
            if (null != this.locale) {
                if (e instanceof ParticleSystem && this.locale.useDistanceFog()) {
                    GL.glDisable((int)2912);
                } else if (this.locale.useDistanceFog()) {
                    GL.glEnable((int)2912);
                }
            }
            ++this.numRenderedEntities;
            ((EntityInterface)this.entityList.get(i)).render();
            if (null == this.locale) continue;
            if (e instanceof ParticleSystem && this.locale.useDistanceFog()) {
                GL.glEnable((int)2912);
                continue;
            }
            if (!this.locale.useDistanceFog()) continue;
            GL.glDisable((int)2912);
        }
        if (null != this.water) {
            this.water.render();
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nLocale: " + this.locale.toString();
        string = string + "\nEntities: ";
        for (int i = 0; i < this.entityList.size(); ++i) {
            string = string + "\n" + i + " " + ((EntityInterface)this.entityList.get(i)).toString();
        }
        return string;
    }
}

