/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.elements;

import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.lwxs.elements.Element;
import de.lessvoid.xml.lwxs.elements.OccursEnum;
import de.lessvoid.xml.lwxs.elements.SubstitutionGroup;
import de.lessvoid.xml.lwxs.elements.XmlProcessorElement;
import de.lessvoid.xml.lwxs.elements.XmlProcessorType;
import java.util.ArrayList;
import java.util.Collection;

public class Type {
    private ArrayList<SubstitutionGroup> substitutionGroups = new ArrayList();
    private ArrayList<Element> elements = new ArrayList();
    private String className;
    private String extendsName;

    public Type() {
    }

    public Type(String classNameParam, String extendsNameParam) throws Exception {
        if (classNameParam == null) {
            throw new Exception("className must not be null");
        }
        this.className = classNameParam;
        this.extendsName = extendsNameParam;
    }

    public void addElement(Element child) {
        this.elements.add(child);
    }

    public void addSubstitutionGroup(SubstitutionGroup substitutionGroup) {
        this.substitutionGroups.add(substitutionGroup);
    }

    public XmlProcessorType createXmlProcessor(Schema schema) throws Exception {
        ArrayList<SubstitutionGroup> substitutionGroups = new ArrayList<SubstitutionGroup>();
        ArrayList<Element> elements = new ArrayList<Element>();
        Type typeParent = this.getTypeParent(schema);
        if (typeParent != null) {
            substitutionGroups.addAll(typeParent.getSubstituitionGroup());
            elements.addAll(typeParent.getElements());
        }
        substitutionGroups.addAll(this.substitutionGroups);
        elements.addAll(this.elements);
        return schema.getInstance(this.className, elements, substitutionGroups);
    }

    private Collection<? extends Element> getElements() {
        return this.elements;
    }

    private Collection<? extends SubstitutionGroup> getSubstituitionGroup() {
        return this.substitutionGroups;
    }

    public XmlProcessorType createXmlProcessorFromType(Schema schema, Type typeParent) throws Exception {
        return schema.getInstance(typeParent.className, this.elements, this.substitutionGroups);
    }

    public Type getTypeParent(Schema schema) throws Exception {
        if (schema.isTypeAvailable(this.extendsName)) {
            return schema.getType(this.extendsName);
        }
        return null;
    }

    public void addChildren(Schema schema, XmlProcessorType processor, String tagName, String tagType, OccursEnum occurs) throws Exception {
        this.childElement(schema, processor, tagName, tagType, occurs);
    }

    private void childElement(Schema schema, XmlProcessorType processor, String tagName, String tagType, OccursEnum occurs) throws Exception {
        XmlProcessorElement child = new XmlProcessorElement(this.createXmlProcessor(schema), tagName, tagType, occurs);
        processor.addElementProcessor(child);
    }

    public String getClassName() {
        return this.className;
    }
}

