/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.dragndrop;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.DroppableDroppedEvent;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.dragndrop.builder.DraggableBuilder;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class DragAndDropDialogController
implements Controller {
    private Nifty nifty;
    private Screen screen;
    private Button resetButton;
    private Element chestOpenElement;
    private Label dragAndDropDescription;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        this.nifty = nifty;
        this.screen = screen;
        this.resetButton = (Button)screen.findNiftyControl("resetButton", Button.class);
        this.chestOpenElement = screen.findElementByName("chest-open");
        this.dragAndDropDescription = (Label)screen.findNiftyControl("dragAndDropDescription", Label.class);
        this.resetButton.disable();
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    @NiftyEventSubscriber(id="chest")
    public void onDrop(String id, DroppableDroppedEvent event) {
        if ("key".equals(event.getDraggable().getId())) {
            event.getDraggable().getElement().markForRemoval();
            this.chestOpenElement.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    DragAndDropDialogController.this.chestOpenElement.hide();
                    DragAndDropDialogController.this.dragAndDropDescription.setText("Well Done!");
                    DragAndDropDialogController.this.resetButton.enable();
                }
            }, "switchOpen");
        }
    }

    @NiftyEventSubscriber(id="resetButton")
    public void onResetButtonClicked(String id, ButtonClickedEvent event) {
        this.resetButton.disable();
        ((Label)this.screen.findNiftyControl("dragAndDropDescription", Label.class)).setText("Well Done!");
        this.dragAndDropDescription.setText("Drop the Key on the Chest to open it.");
        this.chestOpenElement.show();
        this.chestOpenElement.stopEffect(EffectEventId.onCustom);
        new DraggableBuilder("key"){
            {
                this.childLayoutCenter();
                this.image(new ImageBuilder(){
                    {
                        this.filename("defaultcontrols/dragndrop/Key.png");
                    }
                });
            }
        }.build(this.nifty, this.screen, this.screen.findElementByName("key-initial#droppableContent"));
    }
}

