/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.chatcontrol;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Chat;
import de.lessvoid.nifty.controls.ChatTextSendEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.chatcontrol.ChatEntryModelClass;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChatControl
extends AbstractController
implements Chat,
KeyInputHandler {
    private static final String CHAT_BOX = "#chatBox";
    private static final String PLAYER_LIST = "#playerList";
    private static final String CHAT_TEXT_INPUT = "#chat-text-input";
    private static final Logger LOGGER = Logger.getLogger(ChatControl.class.getName());
    private TextField textControl;
    private PlayerComparator playerComparator = new PlayerComparator();
    private Nifty nifty;
    private List<ChatEntryModelClass> playerBuffer = new ArrayList<ChatEntryModelClass>();
    private List<ChatEntryModelClass> linesBuffer = new ArrayList<ChatEntryModelClass>();

    public final void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, Attributes controlDefinitionAttributes) {
        super.bind(newElement);
        LOGGER.fine("binding chat control");
        this.nifty = niftyParam;
        ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
        while (!this.playerBuffer.isEmpty()) {
            ChatEntryModelClass player = this.playerBuffer.remove(0);
            LOGGER.log(Level.FINE, "adding player {0}", playerList.itemCount() + 1);
            playerList.addItem(player);
            playerList.sortAllItems(this.playerComparator);
            playerList.showItem(player);
        }
        ListBox<ChatEntryModelClass> chatBox = this.getListBox(CHAT_BOX);
        while (!this.linesBuffer.isEmpty()) {
            ChatEntryModelClass line = this.linesBuffer.remove(0);
            LOGGER.log(Level.FINE, "adding message {0}", chatBox.itemCount() + 1);
            chatBox.addItem(line);
            chatBox.showItemByIndex(chatBox.itemCount() - 1);
        }
    }

    public void onFocus(boolean arg0) {
        this.textControl.setFocus();
    }

    public final void onStartScreen() {
        LOGGER.fine("starting chat screen");
        this.textControl = (TextField)this.getElement().findNiftyControl(CHAT_TEXT_INPUT, TextField.class);
        this.textControl.getElement().addInputHandler((KeyInputHandler)this);
    }

    @Override
    public final void receivedChatLine(String text, NiftyImage icon) {
        this.receivedChatLine(text, icon, null);
    }

    @Override
    public void receivedChatLine(String text, NiftyImage icon, String style) {
        if (this.linesBuffer.isEmpty()) {
            try {
                ListBox<ChatEntryModelClass> chatBox = this.getListBox(CHAT_BOX);
                LOGGER.log(Level.FINE, "adding message {0}", chatBox.itemCount() + 1);
                ChatEntryModelClass item = new ChatEntryModelClass(text, icon, style);
                chatBox.addItem(item);
                chatBox.showItemByIndex(chatBox.itemCount() - 1);
            }
            catch (NullPointerException npe) {
                this.linesBuffer.add(new ChatEntryModelClass(text, icon, style));
            }
        } else {
            this.linesBuffer.add(new ChatEntryModelClass(text, icon, style));
        }
    }

    @Override
    public final void addPlayer(String playerName, NiftyImage playerIcon) {
        this.addPlayer(playerName, playerIcon, null);
    }

    @Override
    public void addPlayer(String playerName, NiftyImage playerIcon, String style) {
        if (this.playerBuffer.isEmpty()) {
            try {
                ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
                LOGGER.log(Level.FINE, "adding player {0}", playerList.itemCount() + 1);
                ChatEntryModelClass item = new ChatEntryModelClass(playerName, playerIcon, style);
                playerList.addItem(item);
                playerList.sortAllItems(this.playerComparator);
                playerList.showItem(item);
            }
            catch (NullPointerException npe) {
                this.playerBuffer.add(new ChatEntryModelClass(playerName, playerIcon, style));
            }
        } else {
            this.playerBuffer.add(new ChatEntryModelClass(playerName, playerIcon, style));
        }
    }

    @Override
    public final void removePlayer(String playerName) {
        ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
        LOGGER.log(Level.FINE, "removing player {0}", playerName);
        ChatEntryModelClass item = new ChatEntryModelClass(playerName, null);
        playerList.removeItem(item);
    }

    @Override
    public List<ChatEntryModelClass> getPlayers() {
        ListBox<ChatEntryModelClass> playerList = this.getListBox(PLAYER_LIST);
        return playerList.getItems();
    }

    @Override
    public List<ChatEntryModelClass> getLines() {
        ListBox<ChatEntryModelClass> chatBox = this.getListBox(CHAT_BOX);
        return chatBox.getItems();
    }

    @Override
    public void update() {
        this.getListBox(PLAYER_LIST).refresh();
    }

    public final void sendText() {
        String text = this.textControl.getText();
        LOGGER.log(Level.INFO, "sending text {0}", text);
        this.nifty.publishEvent(this.getId(), (NiftyEvent)new ChatTextSendEvent(this, text));
        this.textControl.setText("");
    }

    private ListBox<ChatEntryModelClass> getListBox(String name) {
        return (ListBox)this.getElement().findNiftyControl(name, ListBox.class);
    }

    public boolean keyEvent(NiftyInputEvent inputEvent) {
        LOGGER.log(Level.INFO, "event received: {0}", inputEvent);
        if (inputEvent == NiftyInputEvent.SubmitText) {
            this.sendText();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorRight) {
            // empty if block
        }
        return false;
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return this.keyEvent(inputEvent);
    }

    private class PlayerComparator
    implements Comparator<ChatEntryModelClass> {
        @Override
        public int compare(ChatEntryModelClass player1, ChatEntryModelClass player2) {
            return player1.getLabel().compareToIgnoreCase(player2.getLabel());
        }
    }
}

