/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

public class BitFormat {
    public static final int DEFAULT_MAX_LENGTH = 32;
    public static final int DEFAULT_GROUP_SIZE = 8;
    public static final char DEFAULT_GROUP_SEPARATOR = ' ';
    private int maxLength;
    private int groupSize;
    private char groupSeparator;

    public BitFormat() {
        this(32, 8, ' ');
    }

    public BitFormat(int maxLength) {
        this(maxLength, 8, ' ');
    }

    public BitFormat(int maxLength, int groupSize) {
        this(maxLength, groupSize, ' ');
    }

    public BitFormat(int maxLength, int groupSize, char groupSeparator) {
        this.maxLength = maxLength;
        this.groupSize = groupSize;
        this.groupSeparator = groupSeparator;
    }

    public String format(int n) {
        return this.format(Integer.toBinaryString(n).toCharArray());
    }

    public String format(long n) {
        return this.format(Long.toBinaryString(n).toCharArray());
    }

    private String format(char[] binaryString) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.maxLength; ++i) {
            if ((this.maxLength - i) % this.groupSize == 0 && i > 0) {
                result.append(this.groupSeparator);
            }
            if (i < this.maxLength - binaryString.length) {
                result.append('0');
                continue;
            }
            result.append(binaryString[binaryString.length - this.maxLength + i]);
        }
        return result.toString();
    }
}

