/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ZipClassfileLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;

public class JarClassfileLoader
extends ZipClassfileLoader {
    public JarClassfileLoader(ClassfileLoader loader) {
        super(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load(String filename) {
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + filename));
        JarFile jarfile = null;
        try {
            jarfile = new JarFile(filename);
            this.fireBeginGroup(filename, jarfile.size());
            this.load(jarfile);
            this.fireEndGroup(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass()).error((Object)("Cannot load JAR file \"" + filename + "\""), (Throwable)ex);
        }
        finally {
            if (jarfile != null) {
                try {
                    jarfile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load(String filename, InputStream in) {
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + filename));
        JarInputStream jarfile = null;
        try {
            jarfile = new JarInputStream(in);
            this.fireBeginGroup(filename, -1);
            this.load(jarfile);
            this.fireEndGroup(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass()).error((Object)("Cannot load JAR file \"" + filename + "\""), (Throwable)ex);
        }
        finally {
            if (jarfile != null) {
                try {
                    jarfile.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

