/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.AttributeType;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.EnclosingMethod_attribute;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.LineNumberTable_attribute;
import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.LocalVariableType;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.Signature_attribute;
import com.jeantessier.classreader.SourceDebugExtension_attribute;
import com.jeantessier.classreader.SourceFile_attribute;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.VisitorBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetricsGatherer
extends VisitorBase {
    private Collection<Object> classes = new LinkedList<Object>();
    private Collection<Object> interfaces = new LinkedList<Object>();
    private Collection<Method_info> methods = new LinkedList<Method_info>();
    private Collection<Field_info> fields = new LinkedList<Field_info>();
    private Collection<Classfile> syntheticClasses = new LinkedList<Classfile>();
    private Collection<Field_info> syntheticFields = new LinkedList<Field_info>();
    private Collection<Method_info> syntheticMethods = new LinkedList<Method_info>();
    private Collection<Classfile> deprecatedClasses = new LinkedList<Classfile>();
    private Collection<Field_info> deprecatedFields = new LinkedList<Field_info>();
    private Collection<Method_info> deprecatedMethods = new LinkedList<Method_info>();
    private Collection<Classfile> publicClasses = new LinkedList<Classfile>();
    private Collection<Field_info> publicFields = new LinkedList<Field_info>();
    private Collection<Method_info> publicMethods = new LinkedList<Method_info>();
    private Collection<InnerClass> publicInnerClasses = new LinkedList<InnerClass>();
    private Collection<Field_info> protectedFields = new LinkedList<Field_info>();
    private Collection<Method_info> protectedMethods = new LinkedList<Method_info>();
    private Collection<InnerClass> protectedInnerClasses = new LinkedList<InnerClass>();
    private Collection<Field_info> privateFields = new LinkedList<Field_info>();
    private Collection<Method_info> privateMethods = new LinkedList<Method_info>();
    private Collection<InnerClass> privateInnerClasses = new LinkedList<InnerClass>();
    private Collection<Classfile> packageClasses = new LinkedList<Classfile>();
    private Collection<Field_info> packageFields = new LinkedList<Field_info>();
    private Collection<Method_info> packageMethods = new LinkedList<Method_info>();
    private Collection<InnerClass> packageInnerClasses = new LinkedList<InnerClass>();
    private Collection<Classfile> abstractClasses = new LinkedList<Classfile>();
    private Collection<Method_info> abstractMethods = new LinkedList<Method_info>();
    private Collection<InnerClass> abstractInnerClasses = new LinkedList<InnerClass>();
    private Collection<Field_info> staticFields = new LinkedList<Field_info>();
    private Collection<Method_info> staticMethods = new LinkedList<Method_info>();
    private Collection<InnerClass> staticInnerClasses = new LinkedList<InnerClass>();
    private Collection<Classfile> finalClasses = new LinkedList<Classfile>();
    private Collection<Field_info> finalFields = new LinkedList<Field_info>();
    private Collection<Method_info> finalMethods = new LinkedList<Method_info>();
    private Collection<InnerClass> finalInnerClasses = new LinkedList<InnerClass>();
    private Collection<Method_info> synchronizedMethods = new LinkedList<Method_info>();
    private Collection<Method_info> nativeMethods = new LinkedList<Method_info>();
    private Collection<Field_info> volatileFields = new LinkedList<Field_info>();
    private Collection<Field_info> transientFields = new LinkedList<Field_info>();
    private Map<String, Long> attributeCounts = new HashMap<String, Long>();
    private Collection<Custom_attribute> customAttributes = new LinkedList<Custom_attribute>();
    private long[] instructionCounts = new long[256];

    public MetricsGatherer() {
        for (AttributeType attributeType : AttributeType.values()) {
            this.attributeCounts.put(attributeType.getAttributeName(), 0L);
        }
        this.attributeCounts.put("custom", 0L);
    }

    public Collection<Object> getClasses() {
        return this.classes;
    }

    public Collection<Object> getInterfaces() {
        return this.interfaces;
    }

    public Collection<Method_info> getMethods() {
        return this.methods;
    }

    public Collection<Field_info> getFields() {
        return this.fields;
    }

    public Collection<Classfile> getSyntheticClasses() {
        return this.syntheticClasses;
    }

    public Collection<Field_info> getSyntheticFields() {
        return this.syntheticFields;
    }

    public Collection<Method_info> getSyntheticMethods() {
        return this.syntheticMethods;
    }

    public Collection<Classfile> getDeprecatedClasses() {
        return this.deprecatedClasses;
    }

    public Collection<Field_info> getDeprecatedFields() {
        return this.deprecatedFields;
    }

    public Collection<Method_info> getDeprecatedMethods() {
        return this.deprecatedMethods;
    }

    public Collection<Classfile> getPublicClasses() {
        return this.publicClasses;
    }

    public Collection<Field_info> getPublicFields() {
        return this.publicFields;
    }

    public Collection<Method_info> getPublicMethods() {
        return this.publicMethods;
    }

    public Collection<InnerClass> getPublicInnerClasses() {
        return this.publicInnerClasses;
    }

    public Collection<Field_info> getProtectedFields() {
        return this.protectedFields;
    }

    public Collection<Method_info> getProtectedMethods() {
        return this.protectedMethods;
    }

    public Collection<InnerClass> getProtectedInnerClasses() {
        return this.protectedInnerClasses;
    }

    public Collection<Field_info> getPrivateFields() {
        return this.privateFields;
    }

    public Collection<Method_info> getPrivateMethods() {
        return this.privateMethods;
    }

    public Collection<InnerClass> getPrivateInnerClasses() {
        return this.privateInnerClasses;
    }

    public Collection<Classfile> getPackageClasses() {
        return this.packageClasses;
    }

    public Collection<Field_info> getPackageFields() {
        return this.packageFields;
    }

    public Collection<Method_info> getPackageMethods() {
        return this.packageMethods;
    }

    public Collection<InnerClass> getPackageInnerClasses() {
        return this.packageInnerClasses;
    }

    public Collection<Classfile> getAbstractClasses() {
        return this.abstractClasses;
    }

    public Collection<Method_info> getAbstractMethods() {
        return this.abstractMethods;
    }

    public Collection<InnerClass> getAbstractInnerClasses() {
        return this.abstractInnerClasses;
    }

    public Collection<Field_info> getStaticFields() {
        return this.staticFields;
    }

    public Collection<Method_info> getStaticMethods() {
        return this.staticMethods;
    }

    public Collection<InnerClass> getStaticInnerClasses() {
        return this.staticInnerClasses;
    }

    public Collection<Classfile> getFinalClasses() {
        return this.finalClasses;
    }

    public Collection<Field_info> getFinalFields() {
        return this.finalFields;
    }

    public Collection<Method_info> getFinalMethods() {
        return this.finalMethods;
    }

    public Collection<InnerClass> getFinalInnerClasses() {
        return this.finalInnerClasses;
    }

    public Collection<Method_info> getSynchronizedMethods() {
        return this.synchronizedMethods;
    }

    public Collection<Method_info> getNativeMethods() {
        return this.nativeMethods;
    }

    public Collection<Field_info> getVolatileFields() {
        return this.volatileFields;
    }

    public Collection<Field_info> getTransientFields() {
        return this.transientFields;
    }

    public Map<String, Long> getAttributeCounts() {
        return this.attributeCounts;
    }

    public Collection<Custom_attribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public long[] getInstructionCounts() {
        return this.instructionCounts;
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        if (classfile.isPublic()) {
            this.publicClasses.add(classfile);
        } else {
            this.packageClasses.add(classfile);
        }
        if (classfile.isFinal()) {
            this.finalClasses.add(classfile);
        }
        if (classfile.isInterface()) {
            this.interfaces.add(classfile);
        } else {
            this.classes.add(classfile);
        }
        if (classfile.isAbstract()) {
            this.abstractClasses.add(classfile);
        }
        super.visitClassfile(classfile);
    }

    @Override
    public void visitField_info(Field_info entry) {
        this.fields.add(entry);
        if (entry.isPublic()) {
            this.publicFields.add(entry);
        } else if (entry.isPrivate()) {
            this.privateFields.add(entry);
        } else if (entry.isProtected()) {
            this.protectedFields.add(entry);
        } else {
            this.packageFields.add(entry);
        }
        if (entry.isStatic()) {
            this.staticFields.add(entry);
        }
        if (entry.isFinal()) {
            this.finalFields.add(entry);
        }
        if (entry.isVolatile()) {
            this.volatileFields.add(entry);
        }
        if (entry.isTransient()) {
            this.transientFields.add(entry);
        }
        super.visitField_info(entry);
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.methods.add(entry);
        if (entry.isPublic()) {
            this.publicMethods.add(entry);
        } else if (entry.isPrivate()) {
            this.privateMethods.add(entry);
        } else if (entry.isProtected()) {
            this.protectedMethods.add(entry);
        } else {
            this.packageMethods.add(entry);
        }
        if (entry.isStatic()) {
            this.staticMethods.add(entry);
        }
        if (entry.isFinal()) {
            this.finalMethods.add(entry);
        }
        if (entry.isSynchronized()) {
            this.synchronizedMethods.add(entry);
        }
        if (entry.isNative()) {
            this.nativeMethods.add(entry);
        }
        if (entry.isAbstract()) {
            this.abstractMethods.add(entry);
        }
        super.visitMethod_info(entry);
    }

    @Override
    public void visitConstantValue_attribute(ConstantValue_attribute attribute) {
        super.visitConstantValue_attribute(attribute);
        this.visitAttribute("ConstantValue");
    }

    @Override
    public void visitCode_attribute(Code_attribute attribute) {
        super.visitCode_attribute(attribute);
        this.visitAttribute("Code");
    }

    @Override
    public void visitExceptions_attribute(Exceptions_attribute attribute) {
        super.visitExceptions_attribute(attribute);
        this.visitAttribute("Exceptions");
    }

    @Override
    public void visitInnerClasses_attribute(InnerClasses_attribute attribute) {
        super.visitInnerClasses_attribute(attribute);
        this.visitAttribute("InnerClasses");
    }

    @Override
    public void visitEnclosingMethod_attribute(EnclosingMethod_attribute attribute) {
        super.visitEnclosingMethod_attribute(attribute);
        this.visitAttribute("EnclosingMethod");
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
        super.visitSynthetic_attribute(attribute);
        this.visitAttribute("Synthetic");
        Visitable owner = attribute.getOwner();
        if (owner instanceof Classfile) {
            this.syntheticClasses.add((Classfile)owner);
        } else if (owner instanceof Field_info) {
            this.syntheticFields.add((Field_info)owner);
        } else if (owner instanceof Method_info) {
            this.syntheticMethods.add((Method_info)owner);
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Synthetic attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    @Override
    public void visitSignature_attribute(Signature_attribute attribute) {
        super.visitSignature_attribute(attribute);
        this.visitAttribute("Signature");
    }

    @Override
    public void visitSourceFile_attribute(SourceFile_attribute attribute) {
        super.visitSourceFile_attribute(attribute);
        this.visitAttribute("SourceFile");
    }

    @Override
    public void visitSourceDebugExtension_attribute(SourceDebugExtension_attribute attribute) {
        super.visitSourceDebugExtension_attribute(attribute);
        this.visitAttribute("SourceDebugExtension");
    }

    @Override
    public void visitLineNumberTable_attribute(LineNumberTable_attribute attribute) {
        super.visitLineNumberTable_attribute(attribute);
        this.visitAttribute("LineNumberTable");
    }

    @Override
    public void visitLocalVariableTable_attribute(LocalVariableTable_attribute attribute) {
        super.visitLocalVariableTable_attribute(attribute);
        this.visitAttribute("LocalVariableTable");
    }

    @Override
    public void visitLocalVariableType(LocalVariableType helper) {
        super.visitLocalVariableType(helper);
        this.visitAttribute("LocalVariableTypeTable");
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
        super.visitDeprecated_attribute(attribute);
        this.visitAttribute("Deprecated");
        Visitable owner = attribute.getOwner();
        if (owner instanceof Classfile) {
            this.deprecatedClasses.add((Classfile)owner);
        } else if (owner instanceof Field_info) {
            this.deprecatedFields.add((Field_info)owner);
        } else if (owner instanceof Method_info) {
            this.deprecatedMethods.add((Method_info)owner);
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Deprecated attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    @Override
    public void visitCustom_attribute(Custom_attribute attribute) {
        super.visitCustom_attribute(attribute);
        this.visitAttribute("custom");
        this.customAttributes.add(attribute);
    }

    private void visitAttribute(String attributeName) {
        this.attributeCounts.put(attributeName, this.attributeCounts.get(attributeName) + 1L);
    }

    @Override
    public void visitInstruction(Instruction helper) {
        long[] lArray = this.getInstructionCounts();
        int n = helper.getOpcode();
        lArray[n] = lArray[n] + 1L;
        super.visitInstruction(helper);
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
        if (helper.isPublic()) {
            this.publicInnerClasses.add(helper);
        } else if (helper.isPrivate()) {
            this.privateInnerClasses.add(helper);
        } else if (helper.isProtected()) {
            this.protectedInnerClasses.add(helper);
        } else {
            this.packageInnerClasses.add(helper);
        }
        if (helper.isStatic()) {
            this.staticInnerClasses.add(helper);
        }
        if (helper.isFinal()) {
            this.finalInnerClasses.add(helper);
        }
        if (helper.isInterface()) {
            this.interfaces.add(helper);
        } else {
            this.classes.add(helper);
        }
        if (helper.isAbstract()) {
            this.abstractInnerClasses.add(helper);
        }
    }
}

