/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.Printer;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.UTF8_info;
import java.io.PrintWriter;
import java.util.Collection;

public class TextPrinter
extends Printer {
    private boolean top = true;

    public TextPrinter(PrintWriter out) {
        super(out);
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        this.top = true;
        classfile.getConstantPool().accept(this);
        this.top = false;
        this.eol();
        this.append(classfile.getDeclaration()).append(" {").eol();
        for (Field_info field_info : classfile.getAllFields()) {
            field_info.accept(this);
        }
        for (Method_info method_info : classfile.getAllMethods()) {
            method_info.accept(this);
        }
        this.append("}").eol();
    }

    @Override
    public void visitClass_info(Class_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Class ");
            this.append(entry);
            this.eol();
            this.top = true;
        } else {
            this.append(entry);
        }
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Field ");
            this.append(entry);
            this.eol();
            this.top = true;
        } else {
            this.append(entry);
        }
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Method ");
            this.append(entry);
            this.eol();
            this.top = true;
        } else {
            this.append(entry);
        }
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Interface Method ");
            this.append(entry);
            this.eol();
            this.top = true;
        } else {
            this.append(entry);
        }
    }

    @Override
    public void visitString_info(String_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": String \"");
            entry.getRawValue().accept(this);
            this.append("\"").eol();
            this.top = true;
        } else {
            entry.getRawValue().accept(this);
        }
    }

    @Override
    public void visitInteger_info(Integer_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Integer ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitFloat_info(Float_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Float ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitLong_info(Long_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Long ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitDouble_info(Double_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Double ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitNameAndType_info(NameAndType_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": Name and Type ");
            entry.getRawName().accept(this);
            this.append(" ");
            entry.getRawType().accept(this);
            this.eol();
            this.top = true;
        } else {
            entry.getRawName().accept(this);
            this.append(" ");
            entry.getRawType().accept(this);
        }
    }

    @Override
    public void visitUTF8_info(UTF8_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": \"").append(entry.getValue()).append("\"").eol();
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitField_info(Field_info entry) {
        this.append("    ").append(entry.getDeclaration()).append(";").eol();
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.eol();
        this.append("    ");
        this.append(entry.getDeclaration());
        if (!entry.isStaticInitializer()) {
            this.append(";");
        }
        this.eol();
        if (!entry.isAbstract() && !entry.isNative()) {
            entry.getCode().accept(this);
        }
    }

    @Override
    public void visitCode_attribute(Code_attribute attribute) {
        this.append("        CODE").eol();
        this.visitInstructions(attribute);
        Collection<? extends ExceptionHandler> exceptionHandlers = attribute.getExceptionHandlers();
        if (!exceptionHandlers.isEmpty()) {
            this.append("        EXCEPTION HANDLING").eol();
            this.visitExceptionHandlers(exceptionHandlers);
        }
    }

    @Override
    public void visitInstruction(Instruction helper) {
        this.append("        ").append(helper.getStart()).append(":\t").append(helper.getMnemonic());
        this.appendIndexedConstantPoolEntry(helper);
        this.appendIndexedLocalVariable(helper);
        this.appendOffset(helper);
        this.appendValue(helper);
        this.eol();
        super.visitInstruction(helper);
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
        this.append("        ").append(helper.getStartPC()).append("-").append(helper.getEndPC()).append(": ").append(helper.getHandlerPC());
        if (helper.getCatchTypeIndex() != 0) {
            this.append(" (").append(helper.getCatchType()).append(")");
        }
        this.eol();
    }

    private void appendIndexedConstantPoolEntry(Instruction helper) {
        switch (helper.getOpcode()) {
            case 18: 
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                this.append(" ");
                helper.getIndexedConstantPoolEntry().accept(this);
                break;
            }
        }
    }

    private void appendIndexedLocalVariable(Instruction helper) {
        switch (helper.getOpcode()) {
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.appendLocalVariable(helper.getIndexedLocalVariable());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: 
            case 196: {
                this.appendLocalVariable(helper.getIndexedLocalVariable());
                this.append(" (#").append(helper.getIndex()).append(")");
                break;
            }
        }
    }

    private void appendLocalVariable(LocalVariable localVariable) {
        if (localVariable != null) {
            this.append(" ").append(DescriptorHelper.getType(localVariable.getDescriptor())).append(" ").append(localVariable.getName());
        }
    }

    private void appendOffset(Instruction helper) {
        switch (helper.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                this.append(" ").append(helper.getStart() + helper.getOffset()).append(" (");
                if (helper.getOffset() >= 0) {
                    this.append("+");
                }
                this.append(helper.getOffset());
                this.append(")");
                break;
            }
        }
    }

    private void appendValue(Instruction helper) {
        switch (helper.getOpcode()) {
            case 16: 
            case 17: 
            case 132: {
                this.append(" ").append(helper.getValue());
                break;
            }
            case 196: {
                if (helper.getByte(1) != 132) break;
                this.append(" ").append(helper.getValue());
                break;
            }
        }
    }
}

