/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Annotation;
import com.jeantessier.classreader.AnnotationDefault_attribute;
import com.jeantessier.classreader.AnnotationElementValue;
import com.jeantessier.classreader.ArrayElementValue;
import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.BooleanConstantElementValue;
import com.jeantessier.classreader.ByteConstantElementValue;
import com.jeantessier.classreader.CharConstantElementValue;
import com.jeantessier.classreader.ClassElementValue;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.DoubleConstantElementValue;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.ElementValue;
import com.jeantessier.classreader.ElementValuePair;
import com.jeantessier.classreader.EnclosingMethod_attribute;
import com.jeantessier.classreader.EnumElementValue;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.FloatConstantElementValue;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.IntegerConstantElementValue;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.LineNumberTable_attribute;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.LocalVariableType;
import com.jeantessier.classreader.LocalVariableTypeTable_attribute;
import com.jeantessier.classreader.LongConstantElementValue;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.Parameter;
import com.jeantessier.classreader.RuntimeAnnotations_attribute;
import com.jeantessier.classreader.RuntimeInvisibleAnnotations_attribute;
import com.jeantessier.classreader.RuntimeInvisibleParameterAnnotations_attribute;
import com.jeantessier.classreader.RuntimeParameterAnnotations_attribute;
import com.jeantessier.classreader.RuntimeVisibleAnnotations_attribute;
import com.jeantessier.classreader.RuntimeVisibleParameterAnnotations_attribute;
import com.jeantessier.classreader.ShortConstantElementValue;
import com.jeantessier.classreader.Signature_attribute;
import com.jeantessier.classreader.SourceDebugExtension_attribute;
import com.jeantessier.classreader.SourceFile_attribute;
import com.jeantessier.classreader.StringConstantElementValue;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class VisitorBase
implements Visitor {
    private int currentCount;

    protected void resetCount() {
        this.currentCount = 0;
    }

    protected void incrementCount() {
        ++this.currentCount;
    }

    protected int currentCount() {
        return this.currentCount;
    }

    @Override
    public void visitConstantPool(ConstantPool constantPool) {
        this.resetCount();
        for (ConstantPoolEntry entry : constantPool) {
            if (entry != null) {
                entry.accept(this);
            }
            this.incrementCount();
        }
    }

    @Override
    public void visitClassfiles(Collection<Classfile> classfiles) {
        for (Classfile classfile : classfiles) {
            classfile.accept(this);
        }
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        this.visitClassfileFields(classfile);
        this.visitClassfileMethods(classfile);
        this.visitClassfileAttributes(classfile);
    }

    protected void visitClassfileFields(Classfile classfile) {
        for (Field_info field_info : classfile.getAllFields()) {
            field_info.accept(this);
        }
    }

    protected void visitClassfileMethods(Classfile classfile) {
        for (Method_info method_info : classfile.getAllMethods()) {
            method_info.accept(this);
        }
    }

    protected void visitClassfileAttributes(Classfile classfile) {
        this.visitAttributes(classfile.getAttributes());
    }

    @Override
    public void visitClass_info(Class_info entry) {
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
    }

    @Override
    public void visitString_info(String_info entry) {
    }

    @Override
    public void visitInteger_info(Integer_info entry) {
    }

    @Override
    public void visitFloat_info(Float_info entry) {
    }

    @Override
    public void visitLong_info(Long_info entry) {
    }

    @Override
    public void visitDouble_info(Double_info entry) {
    }

    @Override
    public void visitNameAndType_info(NameAndType_info entry) {
    }

    @Override
    public void visitUTF8_info(UTF8_info entry) {
    }

    @Override
    public void visitField_info(Field_info entry) {
        this.visitAttributes(entry.getAttributes());
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.visitAttributes(entry.getAttributes());
    }

    protected void visitAttributes(Collection<? extends Attribute_info> attributes) {
        for (Attribute_info attribute_info : attributes) {
            attribute_info.accept(this);
        }
    }

    @Override
    public void visitConstantValue_attribute(ConstantValue_attribute attribute) {
    }

    @Override
    public void visitCode_attribute(Code_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)"Visiting instruction(s) ...");
        this.visitInstructions(attribute);
        Collection<? extends ExceptionHandler> exceptionHandlers = attribute.getExceptionHandlers();
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + exceptionHandlers.size() + " exception handler(s) ..."));
        this.visitExceptionHandlers(exceptionHandlers);
        Collection<? extends Attribute_info> attributes = attribute.getAttributes();
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attributes.size() + " code attribute(s) ..."));
        this.visitAttributes(attributes);
    }

    @Override
    public void visitExceptions_attribute(Exceptions_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getExceptions().size() + " exception class(es) ..."));
        for (Class_info class_info : attribute.getExceptions()) {
            class_info.accept(this);
        }
    }

    @Override
    public void visitInnerClasses_attribute(InnerClasses_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getInnerClasses().size() + " inner class(es) ..."));
        for (InnerClass innerClass : attribute.getInnerClasses()) {
            innerClass.accept(this);
        }
    }

    @Override
    public void visitEnclosingMethod_attribute(EnclosingMethod_attribute attribute) {
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
    }

    @Override
    public void visitSignature_attribute(Signature_attribute attribute) {
    }

    @Override
    public void visitSourceFile_attribute(SourceFile_attribute attribute) {
    }

    @Override
    public void visitSourceDebugExtension_attribute(SourceDebugExtension_attribute attribute) {
    }

    @Override
    public void visitLineNumberTable_attribute(LineNumberTable_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getLineNumbers().size() + " line number(s) ..."));
        for (LineNumber lineNumber : attribute.getLineNumbers()) {
            lineNumber.accept(this);
        }
    }

    @Override
    public void visitLocalVariableTable_attribute(LocalVariableTable_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getLocalVariables().size() + " local variable(s) ..."));
        for (LocalVariable localVariable : attribute.getLocalVariables()) {
            localVariable.accept(this);
        }
    }

    @Override
    public void visitLocalVariableTypeTable_attribute(LocalVariableTypeTable_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getLocalVariableTypes().size() + " local variable type(s) ..."));
        for (LocalVariableType localVariableType : attribute.getLocalVariableTypes()) {
            localVariableType.accept(this);
        }
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
    }

    @Override
    public void visitRuntimeVisibleAnnotations_attribute(RuntimeVisibleAnnotations_attribute attribute) {
        this.visitRuntimeAnnotations_attribute(attribute);
    }

    @Override
    public void visitRuntimeInvisibleAnnotations_attribute(RuntimeInvisibleAnnotations_attribute attribute) {
        this.visitRuntimeAnnotations_attribute(attribute);
    }

    protected void visitRuntimeAnnotations_attribute(RuntimeAnnotations_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getAnnotations().size() + " annotation(s) ..."));
        for (Annotation annotation : attribute.getAnnotations()) {
            annotation.accept(this);
        }
    }

    @Override
    public void visitRuntimeVisibleParameterAnnotations_attribute(RuntimeVisibleParameterAnnotations_attribute attribute) {
        this.visitRuntimeParameterAnnotations_attribute(attribute);
    }

    @Override
    public void visitRuntimeInvisibleParameterAnnotations_attribute(RuntimeInvisibleParameterAnnotations_attribute attribute) {
        this.visitRuntimeParameterAnnotations_attribute(attribute);
    }

    protected void visitRuntimeParameterAnnotations_attribute(RuntimeParameterAnnotations_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getParameterAnnotations().size() + " parameter annotation(s) ..."));
        for (Parameter parameter : attribute.getParameterAnnotations()) {
            parameter.accept(this);
        }
    }

    @Override
    public void visitAnnotationDefault_attribute(AnnotationDefault_attribute attribute) {
        attribute.getElemementValue().accept(this);
    }

    @Override
    public void visitCustom_attribute(Custom_attribute attribute) {
    }

    protected void visitInstructions(Code_attribute attribute) {
        for (Instruction instruction : attribute) {
            instruction.accept(this);
        }
    }

    @Override
    public void visitInstruction(Instruction helper) {
    }

    protected void visitExceptionHandlers(Collection<? extends ExceptionHandler> exceptionHandlers) {
        for (ExceptionHandler exceptionHandler : exceptionHandlers) {
            exceptionHandler.accept(this);
        }
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
    }

    @Override
    public void visitLineNumber(LineNumber helper) {
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
    }

    @Override
    public void visitLocalVariableType(LocalVariableType helper) {
    }

    @Override
    public void visitParameter(Parameter helper) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + helper.getAnnotations().size() + " annotation(s) ..."));
        for (Annotation annotation : helper.getAnnotations()) {
            annotation.accept(this);
        }
    }

    @Override
    public void visitAnnotation(Annotation helper) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + helper.getElementValuePairs().size() + " element value pair(s) ..."));
        for (ElementValuePair elementValuePair : helper.getElementValuePairs()) {
            elementValuePair.accept(this);
        }
    }

    @Override
    public void visitElementValuePair(ElementValuePair helper) {
        helper.getElementValue().accept(this);
    }

    @Override
    public void visitByteConstantElementValue(ByteConstantElementValue helper) {
    }

    @Override
    public void visitCharConstantElementValue(CharConstantElementValue helper) {
    }

    @Override
    public void visitDoubleConstantElementValue(DoubleConstantElementValue helper) {
    }

    @Override
    public void visitFloatConstantElementValue(FloatConstantElementValue helper) {
    }

    @Override
    public void visitIntegerConstantElementValue(IntegerConstantElementValue helper) {
    }

    @Override
    public void visitLongConstantElementValue(LongConstantElementValue helper) {
    }

    @Override
    public void visitShortConstantElementValue(ShortConstantElementValue helper) {
    }

    @Override
    public void visitBooleanConstantElementValue(BooleanConstantElementValue helper) {
    }

    @Override
    public void visitStringConstantElementValue(StringConstantElementValue helper) {
    }

    @Override
    public void visitEnumElementValue(EnumElementValue helper) {
    }

    @Override
    public void visitClassElementValue(ClassElementValue helper) {
    }

    @Override
    public void visitAnnotationElementValue(AnnotationElementValue helper) {
        helper.getAnnotation().accept(this);
    }

    @Override
    public void visitArrayElementValue(ArrayElementValue helper) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + helper.getValues().size() + " value(s) ..."));
        for (ElementValue elementValue : helper.getValues()) {
            elementValue.accept(this);
        }
    }
}

