/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.LimitedCollectingParameterStrategy;
import com.jeantessier.commandline.Visitor;

public class ExactlyParameterStrategy
extends LimitedCollectingParameterStrategy {
    public ExactlyParameterStrategy(int nbParameters) {
        super(nbParameters);
    }

    @Override
    public int accept(String param) throws CommandLineException {
        if (this.getParameters().size() < this.getLimit()) {
            return super.accept(param);
        }
        throw new CommandLineException("Exceeding " + this.getLimit() + " parameter(s).");
    }

    @Override
    public void validate() throws CommandLineException {
        if (this.getParameters().size() != this.getLimit()) {
            throw new CommandLineException("Number of parameters (" + this.getParameters().size() + ") must be exactly " + this.getLimit());
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitExactlyParameterStrategy(this);
    }
}

