/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.ComprehensiveSelectionCriteria;
import com.jeantessier.dependency.Cycle;
import com.jeantessier.dependency.CycleComparator;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependency.VisitorBase;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CycleDetector
extends VisitorBase {
    private LinkedList<Node> currentPath = new LinkedList();
    private Collection<Cycle> cycles = new TreeSet<Cycle>(new CycleComparator());
    private int maximumCycleLength = Integer.MAX_VALUE;

    public CycleDetector() {
    }

    public CycleDetector(SelectionCriteria criteria) {
        super(new SelectiveTraversalStrategy(criteria, new ComprehensiveSelectionCriteria()));
    }

    public Collection<Cycle> getCycles() {
        return this.cycles;
    }

    public int getMaximumCycleLength() {
        return this.maximumCycleLength;
    }

    public void setMaximumCycleLength(int maximumCycleLength) {
        this.maximumCycleLength = maximumCycleLength;
    }

    @Override
    protected void preprocessPackageNode(PackageNode node) {
        super.preprocessPackageNode(node);
        this.pushNodeOnCurrentPath(node);
    }

    @Override
    protected void preprocessAfterDependenciesPackageNode(PackageNode node) {
        super.preprocessAfterDependenciesPackageNode(node);
        this.popNodeFromCurrentPath(node);
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
        super.visitOutboundPackageNode(node);
        if (this.getStrategy().isInFilter(node)) {
            if (this.currentPath.getFirst().equals(node) && this.currentPath.size() <= this.getMaximumCycleLength()) {
                this.addCycle();
            } else if (!this.currentPath.contains(node)) {
                this.pushNodeOnCurrentPath(node);
                this.traverseOutbound(node.getOutboundDependencies());
                this.traverseOutbound(node.getClasses());
                this.popNodeFromCurrentPath(node);
            }
        }
    }

    @Override
    protected void preprocessClassNode(ClassNode node) {
        super.preprocessClassNode(node);
        this.pushNodeOnCurrentPath(node);
    }

    @Override
    protected void preprocessAfterDependenciesClassNode(ClassNode node) {
        super.preprocessAfterDependenciesClassNode(node);
        this.popNodeFromCurrentPath(node);
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        super.visitOutboundClassNode(node);
        if (this.getStrategy().isInFilter(node)) {
            if (this.currentPath.getFirst().equals(node) && this.currentPath.size() <= this.getMaximumCycleLength()) {
                this.addCycle();
            } else if (!this.currentPath.contains(node)) {
                this.pushNodeOnCurrentPath(node);
                this.traverseOutbound(node.getOutboundDependencies());
                this.traverseOutbound(node.getFeatures());
                this.popNodeFromCurrentPath(node);
            }
        }
    }

    @Override
    protected void preprocessFeatureNode(FeatureNode node) {
        super.preprocessFeatureNode(node);
        this.pushNodeOnCurrentPath(node);
    }

    @Override
    protected void postprocessFeatureNode(FeatureNode node) {
        super.postprocessFeatureNode(node);
        this.popNodeFromCurrentPath(node);
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        super.visitOutboundFeatureNode(node);
        if (this.getStrategy().isInFilter(node)) {
            if (this.currentPath.getFirst().equals(node) && this.currentPath.size() <= this.getMaximumCycleLength()) {
                this.addCycle();
            } else if (!this.currentPath.contains(node)) {
                this.pushNodeOnCurrentPath(node);
                this.traverseOutbound(node.getOutboundDependencies());
                this.popNodeFromCurrentPath(node);
            }
        }
    }

    private void addCycle() {
        Cycle cycle = new Cycle(this.currentPath);
        this.cycles.add(cycle);
        Logger.getLogger(this.getClass()).debug((Object)("Found cycle " + cycle));
    }

    private void pushNodeOnCurrentPath(Node node) {
        this.currentPath.addLast(node);
        Logger.getLogger(this.getClass()).debug((Object)("Pushed " + node + " on currentPath: " + this.currentPath));
    }

    private void popNodeFromCurrentPath(Node node) {
        Node popedNode = this.currentPath.removeLast();
        Logger.getLogger(this.getClass()).debug((Object)("Popped " + node + " (" + popedNode + ") from currentPath: " + this.currentPath));
    }
}

