/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.Visitor;

public class FeatureNode
extends Node {
    private ClassNode parent;

    public FeatureNode(ClassNode parent, String name, boolean concrete) {
        super(name, concrete);
        this.parent = parent;
    }

    @Override
    void setConfirmed(boolean confirmed) {
        super.setConfirmed(confirmed);
        if (confirmed) {
            this.getClassNode().setConfirmed(confirmed);
        }
    }

    public ClassNode getClassNode() {
        return this.parent;
    }

    @Override
    public boolean canAddDependencyTo(Node node) {
        return super.canAddDependencyTo(node) && this.getClassNode().canAddDependencyTo(node);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitFeatureNode(this);
    }

    @Override
    public void acceptInbound(Visitor visitor) {
        visitor.visitInboundFeatureNode(this);
    }

    @Override
    public void acceptOutbound(Visitor visitor) {
        visitor.visitOutboundFeatureNode(this);
    }

    public String getSimpleName() {
        return this.getName().substring(this.getClassNode().getName().length() + 1);
    }
}

