/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.AttributeType;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.MetricsGatherer;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.classreader.impl.Instruction;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import com.jeantessier.text.Hex;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ClassMetrics
extends Task {
    private boolean list = false;
    private boolean instructionCounts = false;
    private File destfile;
    private Path path;

    public boolean getList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public boolean getInstructioncounts() {
        return this.instructionCounts;
    }

    public void setInstructioncounts(boolean instructionCounts) {
        this.instructionCounts = instructionCounts;
    }

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }

    public Path getPath() {
        return this.path;
    }

    public void execute() throws BuildException {
        if (this.getPath() == null) {
            throw new BuildException("path must be set!");
        }
        if (this.getDestfile() == null) {
            throw new BuildException("destfile must be set!");
        }
        this.log("Reading classes from path " + this.getPath());
        VerboseListener verboseListener = new VerboseListener(this);
        MetricsGatherer metrics = new MetricsGatherer();
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(verboseListener);
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(metrics));
        loader.load(Arrays.asList(this.getPath().list()));
        this.log("Saving class metrics to " + this.getDestfile().getAbsolutePath());
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            out.println(metrics.getClasses().size() + " class(es)");
            if (this.getList()) {
                for (Object o : metrics.getClasses()) {
                    out.println("        " + o);
                }
            }
            out.println(metrics.getInterfaces().size() + " interface(s)");
            if (this.getList()) {
                for (Object o : metrics.getInterfaces()) {
                    out.println("        " + o);
                }
            }
            out.println();
            out.println(metrics.getMethods().size() + " method(s) (average " + (double)metrics.getMethods().size() / ((double)metrics.getClasses().size() + (double)metrics.getInterfaces().size()) + " per class/interface)");
            out.println(metrics.getFields().size() + " field(s) (average " + (double)metrics.getFields().size() / ((double)metrics.getClasses().size() + (double)metrics.getInterfaces().size()) + " per class/interface)");
            out.println();
            this.printCFM(out, " synthetic element(s)", metrics.getSyntheticClasses(), metrics.getSyntheticFields(), metrics.getSyntheticMethods());
            this.printCFM(out, " deprecated element(s)", metrics.getDeprecatedClasses(), metrics.getDeprecatedFields(), metrics.getDeprecatedMethods());
            this.printCFMIC(out, " public element(s)", metrics.getPublicClasses(), metrics.getPublicFields(), metrics.getPublicMethods(), metrics.getPublicInnerClasses());
            this.printFMIC(out, " protected element(s)", metrics.getProtectedFields(), metrics.getProtectedMethods(), metrics.getProtectedInnerClasses());
            this.printFMIC(out, " private element(s)", metrics.getPrivateFields(), metrics.getPrivateMethods(), metrics.getPrivateInnerClasses());
            this.printCFMIC(out, " package element(s)", metrics.getPackageClasses(), metrics.getPackageFields(), metrics.getPackageMethods(), metrics.getPackageInnerClasses());
            this.printCMIC(out, " abstract element(s)", metrics.getAbstractClasses(), metrics.getAbstractMethods(), metrics.getAbstractInnerClasses());
            this.printFMIC(out, " static element(s)", metrics.getStaticFields(), metrics.getStaticMethods(), metrics.getStaticInnerClasses());
            this.printCFMIC(out, " final element(s)", metrics.getFinalClasses(), metrics.getFinalFields(), metrics.getFinalMethods(), metrics.getFinalInnerClasses());
            out.println(metrics.getSynchronizedMethods().size() + " synchronized method(s)");
            if (this.getList()) {
                for (Method_info method : metrics.getSynchronizedMethods()) {
                    out.println("        " + method);
                }
            }
            out.println(metrics.getNativeMethods().size() + " native method(s)");
            if (this.getList()) {
                for (Method_info method : metrics.getNativeMethods()) {
                    out.println("        " + method);
                }
            }
            out.println(metrics.getVolatileFields().size() + " volatile field(s)");
            if (this.getList()) {
                for (Field_info field : metrics.getVolatileFields()) {
                    out.println("        " + field);
                }
            }
            out.println(metrics.getTransientFields().size() + " transient field(s)");
            if (this.getList()) {
                for (Field_info field : metrics.getTransientFields()) {
                    out.println("        " + field);
                }
            }
            for (AttributeType attributeType : AttributeType.values()) {
                out.println(metrics.getAttributeCounts().get(attributeType.getAttributeName()) + " " + attributeType.getAttributeName() + " attribute(s)");
            }
            out.println(metrics.getCustomAttributes().size() + " custom attribute(s)");
            if (this.getList()) {
                for (Custom_attribute attribute : metrics.getCustomAttributes()) {
                    out.println("        " + attribute);
                }
            }
            if (this.getInstructioncounts()) {
                out.println();
                out.println("Instruction counts:");
                for (int opcode = 0; opcode < 256; ++opcode) {
                    out.print("        0x");
                    Hex.print(out, (byte)opcode);
                    out.println(" " + Instruction.getMnemonic(opcode) + ": " + metrics.getInstructionCounts()[opcode]);
                }
            }
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void printCMIC(PrintWriter out, String label, Collection<Classfile> classes, Collection<Method_info> methods, Collection<InnerClass> innerClasses) {
        out.println(classes.size() + methods.size() + innerClasses.size() + label);
        if (this.getList()) {
            out.println("    " + classes.size() + " class(es)");
            for (Classfile aClass : classes) {
                out.println("        " + aClass);
            }
            out.println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                out.println("        " + method);
            }
            out.println("    " + innerClasses.size() + " inner class(es)");
            for (InnerClass innerClass : innerClasses) {
                out.println("        " + innerClass);
            }
        } else {
            out.println("    " + classes.size() + " class(es)");
            out.println("    " + methods.size() + " method(s)");
            out.println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    private void printCFMIC(PrintWriter out, String label, Collection<Classfile> classes, Collection<Field_info> fields, Collection<Method_info> methods, Collection<InnerClass> innerClasses) {
        out.println(classes.size() + fields.size() + methods.size() + innerClasses.size() + label);
        if (this.getList()) {
            out.println("    " + classes.size() + " class(es)");
            for (Classfile aClass : classes) {
                out.println("        " + aClass);
            }
            out.println("    " + fields.size() + " field(s)");
            for (Field_info field : fields) {
                out.println("        " + field);
            }
            out.println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                out.println("        " + method);
            }
            out.println("    " + innerClasses.size() + " inner class(es)");
            for (InnerClass innerClass : innerClasses) {
                out.println("        " + innerClass);
            }
        } else {
            out.println("    " + classes.size() + " class(es)");
            out.println("    " + fields.size() + " fields(s)");
            out.println("    " + methods.size() + " method(s)");
            out.println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    private void printCFM(PrintWriter out, String label, Collection<Classfile> classes, Collection<Field_info> fields, Collection<Method_info> methods) {
        out.println(classes.size() + fields.size() + methods.size() + label);
        if (this.getList()) {
            out.println("    " + classes.size() + " class(es)");
            for (Classfile aClass : classes) {
                out.println("        " + aClass);
            }
            out.println("    " + fields.size() + " field(s)");
            for (Field_info field : fields) {
                out.println("        " + field);
            }
            out.println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                out.println("        " + method);
            }
        } else {
            out.println("    " + classes.size() + " class(es)");
            out.println("    " + fields.size() + " fields(s)");
            out.println("    " + methods.size() + " method(s)");
        }
    }

    private void printFMIC(PrintWriter out, String label, Collection<Field_info> fields, Collection<Method_info> methods, Collection<InnerClass> innerClasses) {
        out.println(fields.size() + methods.size() + innerClasses.size() + label);
        if (this.getList()) {
            out.println("    " + fields.size() + " field(s)");
            for (Field_info field : fields) {
                out.println("        " + field);
            }
            out.println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                out.println("        " + method);
            }
            out.println("    " + innerClasses.size() + " inner class(es)");
            for (InnerClass innerClass : innerClasses) {
                out.println("        " + innerClass);
            }
        } else {
            out.println("    " + fields.size() + " fields(s)");
            out.println("    " + methods.size() + " method(s)");
            out.println("    " + innerClasses.size() + " inner class(es)");
        }
    }
}

