/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.dependency.CollectionSelectionCriteria;
import com.jeantessier.dependency.ComprehensiveSelectionCriteria;
import com.jeantessier.dependency.CycleDetector;
import com.jeantessier.dependency.CyclePrinter;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.RegularExpressionSelectionCriteria;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.TextCyclePrinter;
import com.jeantessier.dependency.XMLCyclePrinter;
import com.jeantessier.dependencyfinder.ant.GraphTask;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.xml.sax.SAXException;

public class DependencyCycles
extends GraphTask {
    private String startIncludes = "//";
    private String startExcludes = "";
    private String packageStartIncludes = "";
    private String packageStartExcludes = "";
    private String classStartIncludes = "";
    private String classStartExcludes = "";
    private String featureStartIncludes = "";
    private String featureStartExcludes = "";
    private Path startIncludesList;
    private Path startExcludesList;
    private String maximumCycleLenth = "";
    private boolean xml = false;
    private String encoding = "utf-8";
    private String dtdPrefix = "http://depfind.sourceforge.net/dtd";
    private String indentText;

    public String getStartincludes() {
        return this.startIncludes;
    }

    public void setStartincludes(String startIncludes) {
        this.startIncludes = startIncludes;
    }

    public String getStartexcludes() {
        return this.startExcludes;
    }

    public void setStartexcludes(String startExcludes) {
        this.startExcludes = startExcludes;
    }

    public String getPackagestartincludes() {
        return this.packageStartIncludes;
    }

    public void setPackagestartincludes(String packageStartIncludes) {
        this.packageStartIncludes = packageStartIncludes;
    }

    public String getPackagestartexcludes() {
        return this.packageStartExcludes;
    }

    public void setPackagestartexcludes(String packageStartExcludes) {
        this.packageStartExcludes = packageStartExcludes;
    }

    public String getClassstartincludes() {
        return this.classStartIncludes;
    }

    public void setClassstartincludes(String classStartIncludes) {
        this.classStartIncludes = classStartIncludes;
    }

    public String getClassstartexcludes() {
        return this.classStartExcludes;
    }

    public void setClassstartexcludes(String classStartExcludes) {
        this.classStartExcludes = classStartExcludes;
    }

    public String getFeaturestartincludes() {
        return this.featureStartIncludes;
    }

    public void setFeaturestartincludes(String featureStartIncludes) {
        this.featureStartIncludes = featureStartIncludes;
    }

    public String getFeaturestartexcludes() {
        return this.featureStartExcludes;
    }

    public void setFeaturestartexcludes(String featureStartExcludes) {
        this.featureStartExcludes = featureStartExcludes;
    }

    public Path createStartincludeslist() {
        if (this.startIncludesList == null) {
            this.startIncludesList = new Path(this.getProject());
        }
        return this.startIncludesList;
    }

    public Path getStartincludeslist() {
        return this.startIncludesList;
    }

    public Path createStartexcludeslist() {
        if (this.startExcludesList == null) {
            this.startExcludesList = new Path(this.getProject());
        }
        return this.startExcludesList;
    }

    public Path getStartexcludeslist() {
        return this.startExcludesList;
    }

    public String getMaximumcyclelength() {
        return this.maximumCycleLenth;
    }

    public void setMaximumcyclelength(String maximumCycleLenth) {
        this.maximumCycleLenth = maximumCycleLenth;
    }

    public boolean getXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDtdprefix() {
        return this.dtdPrefix;
    }

    public void setDtdprefix(String dtdPrefix) {
        this.dtdPrefix = dtdPrefix;
    }

    public String getIndenttext() {
        return this.indentText;
    }

    public void setIntenttext(String indentText) {
        this.indentText = indentText;
    }

    @Override
    protected void validateParameters() throws BuildException {
        super.validateParameters();
        if (this.hasStartRegularExpressionSwitches() && this.hasStartListSwitches()) {
            throw new BuildException("Cannot have start attributes for regular expressions and lists at the same time!");
        }
    }

    public void execute() throws BuildException {
        this.validateParameters();
        VerboseListener verboseListener = new VerboseListener(this);
        try {
            NodeFactory factory = new NodeFactory();
            for (String filename : this.getSrc().list()) {
                this.log("Reading graph from " + filename);
                if (!filename.endsWith(".xml")) continue;
                NodeLoader loader = new NodeLoader(factory, this.getValidate());
                loader.addDependencyListener(verboseListener);
                loader.load(filename);
            }
            CycleDetector detector = new CycleDetector(this.getStartCriteria());
            if (this.getMaximumcyclelength() != null) {
                detector.setMaximumCycleLength(Integer.parseInt(this.getMaximumcyclelength()));
            }
            detector.traverseNodes(factory.getPackages().values());
            this.log("Saving dependency cycles to " + this.getDestfile().getAbsolutePath());
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            CyclePrinter printer = this.getXml() ? new XMLCyclePrinter(out, this.getEncoding(), this.getDtdprefix()) : new TextCyclePrinter(out);
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.visitCycles(detector.getCycles());
            out.close();
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    protected SelectionCriteria getStartCriteria() throws BuildException {
        SelectionCriteria result = new ComprehensiveSelectionCriteria();
        if (this.hasStartRegularExpressionSwitches()) {
            result = this.createRegularExpressionStartCriteria();
        } else if (this.hasStartListSwitches()) {
            result = this.createCollectionSelectionCriteria(this.getStartincludeslist(), this.getStartexcludeslist());
        }
        return result;
    }

    protected RegularExpressionSelectionCriteria createRegularExpressionStartCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        result.setGlobalIncludes(this.getStartincludes());
        result.setGlobalExcludes(this.getStartexcludes());
        result.setPackageIncludes(this.getPackagestartincludes());
        result.setPackageExcludes(this.getPackagestartexcludes());
        result.setClassIncludes(this.getClassstartincludes());
        result.setClassExcludes(this.getClassstartexcludes());
        result.setFeatureIncludes(this.getFeaturestartincludes());
        result.setFeatureExcludes(this.getFeaturestartexcludes());
        return result;
    }

    private CollectionSelectionCriteria createCollectionSelectionCriteria(Path includes, Path excludes) {
        return new CollectionSelectionCriteria(this.loadCollection(includes), this.loadCollection(excludes));
    }

    private boolean hasStartRegularExpressionSwitches() {
        return !this.getStartincludes().equals("//") || !this.getStartexcludes().equals("") || !this.getPackagestartincludes().equals("") || !this.getPackagestartexcludes().equals("") || !this.getClassstartincludes().equals("") || !this.getClassstartexcludes().equals("") || !this.getFeaturestartincludes().equals("") || !this.getFeaturestartexcludes().equals("");
    }

    private boolean hasStartListSwitches() {
        return this.getStartincludeslist() != null || this.getStartexcludeslist() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> loadCollection(Path path) {
        HashSet<String> result = null;
        if (path != null) {
            result = new HashSet<String>();
            for (String filename : path.list()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(filename));
                    while ((line = reader.readLine()) != null) {
                        result.add(line);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)("Couldn't read file " + filename), (Throwable)ex);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)("Couldn't close file " + filename), (Throwable)ex);
                    }
                }
            }
        }
        return result;
    }
}

