/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.dependency.MetricsGatherer;
import com.jeantessier.dependency.MetricsReport;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.RegularExpressionSelectionCriteria;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependencyfinder.ant.GraphTask;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;

public class DependencyMetrics
extends GraphTask {
    private String scopeIncludes = "//";
    private String scopeExcludes = "";
    private boolean packageScope;
    private String packageScopeIncludes = "";
    private String packageScopeExcludes = "";
    private boolean classScope;
    private String classScopeIncludes = "";
    private String classScopeExcludes = "";
    private boolean featureScope;
    private String featureScopeIncludes = "";
    private String featureScopeExcludes = "";
    private String filterIncludes = "//";
    private String filterExcludes = "";
    private boolean packageFilter;
    private String packageFilterIncludes = "";
    private String packageFilterExcludes = "";
    private boolean classFilter;
    private String classFilterIncludes = "";
    private String classFilterExcludes = "";
    private boolean featureFilter;
    private String featureFilterIncludes = "";
    private String featureFilterExcludes = "";
    private boolean list = false;
    private boolean chartClassesPerPackage = false;
    private boolean chartFeaturesPerClass = false;
    private boolean chartInboundsPerPackage = false;
    private boolean chartOutboundsPerPackage = false;
    private boolean chartInboundsPerClass = false;
    private boolean chartOutboundsPerClass = false;
    private boolean chartInboundsPerFeature = false;
    private boolean chartOutboundsPerFeature = false;

    public String getScopeincludes() {
        return this.scopeIncludes;
    }

    public void setScopeincludes(String scopeIncludes) {
        this.scopeIncludes = scopeIncludes;
    }

    public String getScopeexcludes() {
        return this.scopeExcludes;
    }

    public void setScopeexcludes(String scopeExcludes) {
        this.scopeExcludes = scopeExcludes;
    }

    public boolean getPackagescope() {
        return this.packageScope;
    }

    public void setPackagescope(boolean packageScope) {
        this.packageScope = packageScope;
    }

    public String getPackagescopeincludes() {
        return this.packageScopeIncludes;
    }

    public void setPackagescopeincludes(String packageScopeIncludes) {
        this.packageScopeIncludes = packageScopeIncludes;
    }

    public String getPackagescopeexcludes() {
        return this.packageScopeExcludes;
    }

    public void setPackagescopeexcludes(String packageScopeExcludes) {
        this.packageScopeExcludes = packageScopeExcludes;
    }

    public boolean getClassscope() {
        return this.classScope;
    }

    public void setClassscope(boolean classScope) {
        this.classScope = classScope;
    }

    public String getClassscopeincludes() {
        return this.classScopeIncludes;
    }

    public void setClassscopeincludes(String classScopeIncludes) {
        this.classScopeIncludes = classScopeIncludes;
    }

    public String getClassscopeexcludes() {
        return this.classScopeExcludes;
    }

    public void setClassscopeexcludes(String classScopeExcludes) {
        this.classScopeExcludes = classScopeExcludes;
    }

    public boolean getFeaturescope() {
        return this.featureScope;
    }

    public void setFeaturescope(boolean featureScope) {
        this.featureScope = featureScope;
    }

    public String getFeaturescopeincludes() {
        return this.featureScopeIncludes;
    }

    public void setFeaturescopeincludes(String featureScopeIncludes) {
        this.featureScopeIncludes = featureScopeIncludes;
    }

    public String getFeaturescopeexcludes() {
        return this.featureScopeExcludes;
    }

    public void setFeaturescopeexcludes(String featureScopeExcludes) {
        this.featureScopeExcludes = featureScopeExcludes;
    }

    public String getFilterincludes() {
        return this.filterIncludes;
    }

    public void setFilterincludes(String filterIncludes) {
        this.filterIncludes = filterIncludes;
    }

    public String getFilterexcludes() {
        return this.filterExcludes;
    }

    public void setFilterexcludes(String filterExcludes) {
        this.filterExcludes = filterExcludes;
    }

    public boolean getPackagefilter() {
        return this.packageFilter;
    }

    public void setPackagefilter(boolean packageFilter) {
        this.packageFilter = packageFilter;
    }

    public String getPackagefilterincludes() {
        return this.packageFilterIncludes;
    }

    public void setPackagefilterincludes(String packageFilterIncludes) {
        this.packageFilterIncludes = packageFilterIncludes;
    }

    public String getPackagefilterexcludes() {
        return this.packageFilterExcludes;
    }

    public void setPackagefilterexcludes(String packageFilterExcludes) {
        this.packageFilterExcludes = packageFilterExcludes;
    }

    public boolean getClassfilter() {
        return this.classFilter;
    }

    public void setClassfilter(boolean classFilter) {
        this.classFilter = classFilter;
    }

    public String getClassfilterincludes() {
        return this.classFilterIncludes;
    }

    public void setClassfilterincludes(String classFilterIncludes) {
        this.classFilterIncludes = classFilterIncludes;
    }

    public String getClassfilterexcludes() {
        return this.classFilterExcludes;
    }

    public void setClassfilterexcludes(String classFilterExcludes) {
        this.classFilterExcludes = classFilterExcludes;
    }

    public boolean getFeaturefilter() {
        return this.featureFilter;
    }

    public void setFeaturefilter(boolean featureFilter) {
        this.featureFilter = featureFilter;
    }

    public String getFeaturefilterincludes() {
        return this.featureFilterIncludes;
    }

    public void setFeaturefilterincludes(String featureFilterIncludes) {
        this.featureFilterIncludes = featureFilterIncludes;
    }

    public String getFeaturefilterexcludes() {
        return this.featureFilterExcludes;
    }

    public void setFeaturefilterexcludes(String featureFilterExcludes) {
        this.featureFilterExcludes = featureFilterExcludes;
    }

    public void setP2p(boolean value) {
        this.setPackagescope(value);
        this.setPackagefilter(value);
    }

    public void setC2p(boolean value) {
        this.setClassscope(value);
        this.setPackagefilter(value);
    }

    public void setC2c(boolean value) {
        this.setClassscope(value);
        this.setClassfilter(value);
    }

    public void setF2f(boolean value) {
        this.setFeaturescope(value);
        this.setFeaturefilter(value);
    }

    public void setIncludes(String value) {
        this.setScopeincludes(value);
        this.setFilterincludes(value);
    }

    public void setExcludes(String value) {
        this.setScopeexcludes(value);
        this.setFilterexcludes(value);
    }

    public boolean getList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public boolean getChartclassesperpackage() {
        return this.chartClassesPerPackage;
    }

    public void setChartclassesperpackage(boolean chartClassesPerPackage) {
        this.chartClassesPerPackage = chartClassesPerPackage;
    }

    public boolean getChartfeaturesperclass() {
        return this.chartFeaturesPerClass;
    }

    public void setChartfeaturesperclass(boolean chartFeaturesPerClass) {
        this.chartFeaturesPerClass = chartFeaturesPerClass;
    }

    public boolean getChartinboundsperpackage() {
        return this.chartInboundsPerPackage;
    }

    public void setChartinboundsperpackage(boolean chartInboundsPerPackage) {
        this.chartInboundsPerPackage = chartInboundsPerPackage;
    }

    public boolean getChartoutboundsperpackage() {
        return this.chartOutboundsPerPackage;
    }

    public void setChartoutboundsperpackage(boolean chartOutboundsPerPackage) {
        this.chartOutboundsPerPackage = chartOutboundsPerPackage;
    }

    public boolean getChartinboundsperclass() {
        return this.chartInboundsPerClass;
    }

    public void setChartinboundsperclass(boolean chartInboundsPerClass) {
        this.chartInboundsPerClass = chartInboundsPerClass;
    }

    public boolean getChartoutboundsperclass() {
        return this.chartOutboundsPerClass;
    }

    public void setChartoutboundsperclass(boolean chartOutboundsPerClass) {
        this.chartOutboundsPerClass = chartOutboundsPerClass;
    }

    public boolean getChartinboundsperfeature() {
        return this.chartInboundsPerFeature;
    }

    public void setChartinboundsperfeature(boolean chartInboundsPerFeature) {
        this.chartInboundsPerFeature = chartInboundsPerFeature;
    }

    public boolean getChartoutboundsperfeature() {
        return this.chartOutboundsPerFeature;
    }

    public void setChartoutboundsperfeature(boolean chartOutboundsPerFeature) {
        this.chartOutboundsPerFeature = chartOutboundsPerFeature;
    }

    public void setChartinbounds(boolean chartInbounds) {
        this.setChartinboundsperpackage(chartInbounds);
        this.setChartinboundsperclass(chartInbounds);
        this.setChartinboundsperfeature(chartInbounds);
    }

    public void setChartoutbounds(boolean chartOutbounds) {
        this.setChartoutboundsperpackage(chartOutbounds);
        this.setChartoutboundsperclass(chartOutbounds);
        this.setChartoutboundsperfeature(chartOutbounds);
    }

    public void setChartpackages(boolean chartPackages) {
        this.setChartclassesperpackage(chartPackages);
        this.setChartinboundsperpackage(chartPackages);
        this.setChartoutboundsperpackage(chartPackages);
    }

    public void setChartclasses(boolean chartClasses) {
        this.setChartfeaturesperclass(chartClasses);
        this.setChartinboundsperclass(chartClasses);
        this.setChartoutboundsperclass(chartClasses);
    }

    public void setChartfeatures(boolean chartFeatures) {
        this.setChartinboundsperfeature(chartFeatures);
        this.setChartoutboundsperfeature(chartFeatures);
    }

    public void setChartall(boolean chartAll) {
        this.setChartclassesperpackage(chartAll);
        this.setChartfeaturesperclass(chartAll);
        this.setChartinboundsperpackage(chartAll);
        this.setChartoutboundsperpackage(chartAll);
        this.setChartinboundsperclass(chartAll);
        this.setChartoutboundsperclass(chartAll);
        this.setChartinboundsperfeature(chartAll);
        this.setChartoutboundsperfeature(chartAll);
    }

    public void execute() throws BuildException {
        this.validateParameters();
        VerboseListener verboseListener = new VerboseListener(this);
        try {
            NodeFactory factory = new NodeFactory();
            for (String filename : this.getSrc().list()) {
                this.log("Reading graph from " + filename);
                if (!filename.endsWith(".xml")) continue;
                NodeLoader loader = new NodeLoader(factory, this.getValidate());
                loader.addDependencyListener(verboseListener);
                loader.load(filename);
            }
            this.log("Saving metrics report to " + this.getDestfile().getAbsolutePath());
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            MetricsReport reporter = new MetricsReport(out);
            reporter.setListingElements(this.getList());
            reporter.setChartingClassesPerPackage(this.getChartclassesperpackage());
            reporter.setChartingFeaturesPerClass(this.getChartfeaturesperclass());
            reporter.setChartingInboundsPerPackage(this.getChartinboundsperpackage());
            reporter.setChartingOutboundsPerPackage(this.getChartoutboundsperpackage());
            reporter.setChartingInboundsPerClass(this.getChartinboundsperclass());
            reporter.setChartingOutboundsPerClass(this.getChartoutboundsperclass());
            reporter.setChartingInboundsPerFeature(this.getChartinboundsperfeature());
            reporter.setChartingOutboundsPerFeature(this.getChartoutboundsperfeature());
            MetricsGatherer metrics = new MetricsGatherer(this.getStrategy());
            metrics.traverseNodes(factory.getPackages().values());
            reporter.process(metrics);
            out.close();
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private SelectionCriteria getScopeCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        if (this.getPackagescope() || this.getClassscope() || this.getFeaturescope()) {
            result.setMatchingPackages(this.getPackagescope());
            result.setMatchingClasses(this.getClassscope());
            result.setMatchingFeatures(this.getFeaturescope());
        }
        result.setGlobalIncludes(this.getScopeincludes());
        result.setGlobalExcludes(this.getScopeexcludes());
        result.setPackageIncludes(this.getPackagescopeincludes());
        result.setPackageExcludes(this.getPackagescopeexcludes());
        result.setClassIncludes(this.getClassscopeincludes());
        result.setClassExcludes(this.getClassscopeexcludes());
        result.setFeatureIncludes(this.getFeaturescopeincludes());
        result.setFeatureExcludes(this.getFeaturescopeexcludes());
        return result;
    }

    private SelectionCriteria getFilterCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        if (this.getPackagefilter() || this.getClassfilter() || this.getFeaturefilter()) {
            result.setMatchingPackages(this.getPackagefilter());
            result.setMatchingClasses(this.getClassfilter());
            result.setMatchingFeatures(this.getFeaturefilter());
        }
        result.setGlobalIncludes(this.getFilterincludes());
        result.setGlobalExcludes(this.getFilterexcludes());
        result.setPackageIncludes(this.getPackagefilterincludes());
        result.setPackageExcludes(this.getPackagefilterexcludes());
        result.setClassIncludes(this.getClassfilterincludes());
        result.setClassExcludes(this.getClassfilterexcludes());
        result.setFeatureIncludes(this.getFeaturefilterincludes());
        result.setFeatureExcludes(this.getFeaturefilterexcludes());
        return result;
    }

    private TraversalStrategy getStrategy() throws BuildException {
        return new SelectiveTraversalStrategy(this.getScopeCriteria(), this.getFilterCriteria());
    }
}

