/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.text.Hex;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CodeDifferenceStrategy
implements DifferenceStrategy {
    @Override
    public boolean isPackageDifferent(Map<String, Classfile> oldPackage, Map<String, Classfile> newPackage) {
        return false;
    }

    @Override
    public boolean isClassDifferent(Classfile oldClass, Classfile newClass) {
        return false;
    }

    @Override
    public boolean isDeclarationModified(Classfile oldClass, Classfile newClass) {
        return false;
    }

    @Override
    public boolean isFieldDifferent(Field_info oldField, Field_info newField) {
        return false;
    }

    @Override
    public boolean isConstantValueDifferent(ConstantValue_attribute oldValue, ConstantValue_attribute newValue) {
        boolean result = oldValue != null ? !oldValue.equals(newValue) : oldValue != newValue;
        return result;
    }

    @Override
    public boolean isMethodDifferent(Method_info oldMethod, Method_info newMethod) {
        return false;
    }

    @Override
    public boolean isCodeDifferent(Code_attribute oldCode, Code_attribute newCode) {
        boolean result;
        if (oldCode != null && newCode != null) {
            result = oldCode.getCode().length != newCode.getCode().length;
            Iterator<Instruction> oldIterator = oldCode.iterator();
            Iterator<Instruction> newIterator = newCode.iterator();
            while (!result && oldIterator.hasNext() && newIterator.hasNext()) {
                Instruction newInstruction;
                Instruction oldInstruction = oldIterator.next();
                result = !oldInstruction.equals(newInstruction = newIterator.next());
            }
            if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
                Logger.getLogger(this.getClass()).debug((Object)("Code compare for " + oldCode.getOwner()));
                Logger.getLogger(this.getClass()).debug((Object)("old code: " + Hex.toString(oldCode.getCode())));
                Logger.getLogger(this.getClass()).debug((Object)("new code: " + Hex.toString(newCode.getCode())));
                Logger.getLogger(this.getClass()).debug((Object)(result ? "[different]" : "[same]"));
            }
        } else {
            result = oldCode != newCode;
        }
        return result;
    }
}

