/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.os.NativeLibrary;
import java.nio.ByteBuffer;

public abstract class AbstractBuffer
implements NativeBuffer {
    protected final ByteBuffer bb;
    protected int capacity;
    protected int position;

    protected AbstractBuffer(ByteBuffer bb, int elementSize) {
        this.bb = bb;
        this.capacity = bb.capacity() / elementSize;
        this.position = 0;
    }

    @Override
    public final int limit() {
        return this.capacity;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final NativeBuffer position(int newPos) {
        if (0 > newPos || newPos >= this.capacity) {
            throw new IndexOutOfBoundsException("Sorry to interrupt, but the position " + newPos + " was out of bounds. " + "My capacity is " + this.capacity() + ".");
        }
        this.position = newPos;
        return this;
    }

    @Override
    public final int remaining() {
        return this.capacity - this.position;
    }

    @Override
    public final boolean hasRemaining() {
        return this.position < this.capacity;
    }

    @Override
    public final NativeBuffer rewind() {
        this.position = 0;
        return this;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public final ByteBuffer getBuffer() {
        return this.bb;
    }

    @Override
    public final boolean isDirect() {
        return this.bb.isDirect();
    }

    public String toString() {
        return "AbstractBuffer[capacity " + this.capacity + ", position " + this.position + ", elementSize " + this.bb.capacity() / this.capacity + ", ByteBuffer.capacity " + this.bb.capacity() + "]";
    }

    static {
        NativeLibrary.ensureNativeLibLoaded();
    }
}

