/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.PointerBuffer;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    protected static final boolean DEBUG = GraphicsConfigurationFactory.DEBUG || Debug.debug("EGL");
    static EGLGLCapabilities.EglCfgIDComparator EglCfgIDComparator = new EGLGLCapabilities.EglCfgIDComparator();

    EGLGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory(EGLGraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (abstractGraphicsScreen == null) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only AbstractGraphicsDevice objects");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        return EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen);
    }

    protected static List getAvailableCapabilities(EGLDrawableFactory eGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        GLProfile gLProfile;
        EGLDrawableFactory.SharedResource sharedResource = eGLDrawableFactory.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        EGLGraphicsDevice eGLGraphicsDevice = sharedResource.getDevice();
        long l = eGLGraphicsDevice.getHandle();
        List list = null;
        int[] nArray = new int[1];
        if (!EGL.eglGetConfigs(l, null, 0, nArray, 0)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString((int)EGL.eglGetError()));
        }
        if (0 == nArray[0]) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) no configs");
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)nArray[0]);
        int[] nArray2 = new int[1];
        if (!EGL.eglGetConfigs(l, pointerBuffer, pointerBuffer.capacity(), nArray2, 0)) {
            throw new GLException("Graphics configuration get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString((int)EGL.eglGetError()));
        }
        if (nArray2[0] > 0 && null != (list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile = GLProfile.getDefault(abstractGraphicsDevice), l, pointerBuffer, nArray2[0], 7))) {
            Collections.sort(list, EglCfgIDComparator);
        }
        return list;
    }

    private static EGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        if (null == abstractGraphicsScreen) {
            throw new GLException("Null AbstractGraphicsScreen");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        EGLDrawableFactory eGLDrawableFactory = (EGLDrawableFactory)GLDrawableFactory.getEGLFactory();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, eGLDrawableFactory.canCreateGLPbuffer(abstractGraphicsDevice));
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen);
        if (null != eGLGraphicsConfiguration) {
            return eGLGraphicsConfiguration;
        }
        if (DEBUG) {
            System.err.println("eglChooseConfig failed with given capabilities " + gLCapabilitiesImmutable);
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        if (DEBUG) {
            System.err.println("trying fixed caps (1): " + gLCapabilities);
        }
        if (null != (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return eGLGraphicsConfiguration;
        }
        gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(6);
        gLCapabilities.setBlueBits(5);
        gLCapabilities.setDepthBits(16);
        if (DEBUG) {
            System.err.println("trying fixed caps (2): " + gLCapabilities);
        }
        if (null != (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return eGLGraphicsConfiguration;
        }
        gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(6);
        gLCapabilities.setBlueBits(5);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        if (DEBUG) {
            System.err.println("trying fixed caps (3): " + gLCapabilities);
        }
        if (null != (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return eGLGraphicsConfiguration;
        }
        throw new GLException("Graphics configuration failed [direct caps, eglGetConfig/chooser and fixed-caps(1-3)]");
    }

    static EGLGraphicsConfiguration eglChooseConfig(long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl = gLCapabilitiesImmutable.isOnscreen();
        boolean bl2 = gLCapabilitiesImmutable.isPBuffer();
        List list = null;
        int n = GLGraphicsConfigurationUtil.getWinAttributeBits(bl, bl2);
        int n2 = -1;
        long l2 = -1L;
        int[] nArray = new int[1];
        if (!EGL.eglGetConfigs(l, null, 0, nArray, 0)) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString((int)EGL.eglGetError()));
        }
        if (0 == nArray[0]) {
            throw new GLException("Graphics configuration get maxConfigs (eglGetConfigs) no configs");
        }
        if (DEBUG) {
            System.err.println("!!! eglChooseConfig maxConfigs: " + nArray[0]);
        }
        int[] nArray2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)nArray[0]);
        int[] nArray3 = new int[1];
        if (!EGL.eglChooseConfig(l, nArray2, 0, pointerBuffer, pointerBuffer.capacity(), nArray3, 0)) {
            throw new GLException("Graphics configuration selection (eglChooseConfig) failed for " + gLCapabilitiesImmutable + ", error " + EGLGraphicsConfigurationFactory.toHexString((int)EGL.eglGetError()));
        }
        if (nArray3[0] > 0) {
            list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, pointerBuffer, nArray3[0], n);
            if (list.size() > 0) {
                l2 = pointerBuffer.get(0);
                n2 = 0;
                if (DEBUG) {
                    System.err.println("!!! eglChooseConfig recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString((long)l2) + ", idx " + n2);
                    System.err.println("!!! user  caps " + gLCapabilitiesImmutable);
                    System.err.println("!!! fbcfg caps " + list.get(n2));
                }
            } else if (DEBUG) {
                System.err.println("!!! eglChooseConfig no caps for recommended fbcfg " + EGLGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(0)));
                System.err.println("!!! user  caps " + gLCapabilitiesImmutable);
            }
        }
        if (null == list || 0 == list.size()) {
            l2 = -1L;
            n2 = -1;
            if (!EGL.eglGetConfigs(l, pointerBuffer, pointerBuffer.capacity(), nArray3, 0)) {
                throw new GLException("Graphics configuration get all configs (eglGetConfigs) call failed, error " + EGLGraphicsConfigurationFactory.toHexString((int)EGL.eglGetError()));
            }
            if (nArray3[0] > 0) {
                list = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, pointerBuffer, nArray3[0], n);
            }
        }
        if (null == list || 0 == list.size()) {
            if (DEBUG) {
                System.err.println("Graphics configuration 1st choice and 2nd choice failed - no configs");
            }
            return null;
        }
        int n3 = EGLGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, list, n2);
        if (0 > n3) {
            if (DEBUG) {
                Thread.dumpStack();
            }
            return null;
        }
        EGLGLCapabilities eGLGLCapabilities = (EGLGLCapabilities)list.get(n3);
        return new EGLGraphicsConfiguration(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }

    static List eglConfigs2GLCaps(GLProfile gLProfile, long l, PointerBuffer pointerBuffer, int n, int n2) {
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            EGLGraphicsConfiguration.EGLConfig2Capabilities(arrayList, gLProfile, l, pointerBuffer.get(i), n2);
        }
        return arrayList;
    }

    static void printCaps(String string, List list, PrintStream printStream) {
        for (int i = 0; i < list.size(); ++i) {
            printStream.println(string + "[" + i + "] " + list.get(i));
        }
    }

    static EGLGraphicsConfiguration createOffscreenGraphicsConfiguration(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        EGLGraphicsConfiguration eGLGraphicsConfiguration;
        GLCapabilities gLCapabilities;
        if (gLCapabilitiesImmutable.isOnscreen()) {
            throw new GLException("Error: Onscreen set: " + gLCapabilitiesImmutable);
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilitiesImmutable = gLCapabilities;
        }
        if (null == (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, (AbstractGraphicsScreen)(gLCapabilities = new DefaultGraphicsScreen(abstractGraphicsDevice, 0))))) {
            throw new GLException("Couldn't create EGLGraphicsConfiguration from " + gLCapabilities);
        }
        if (DEBUG) {
            System.err.println("Chosen eglConfig: " + eGLGraphicsConfiguration);
        }
        return eGLGraphicsConfiguration;
    }
}

