/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.PointerBuffer;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Util;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.Debug;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11GLCapabilities;

public class X11GLXGraphicsConfiguration
extends X11GraphicsConfiguration
implements Cloneable {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    public static final int MAX_ATTRIBS = 128;
    private GLCapabilitiesChooser chooser;

    X11GLXGraphicsConfiguration(X11GraphicsScreen x11GraphicsScreen, X11GLCapabilities x11GLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(x11GraphicsScreen, (CapabilitiesImmutable)x11GLCapabilities, (CapabilitiesImmutable)gLCapabilitiesImmutable, x11GLCapabilities.getXVisualInfo());
        this.chooser = gLCapabilitiesChooser;
    }

    static X11GLXGraphicsConfiguration create(GLProfile gLProfile, X11GraphicsScreen x11GraphicsScreen, int n) {
        X11GLCapabilities x11GLCapabilities;
        long l = x11GraphicsScreen.getDevice().getHandle();
        if (0L == l) {
            throw new GLException("Display null of " + x11GraphicsScreen);
        }
        int n2 = x11GraphicsScreen.getIndex();
        long l2 = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l, n2, n);
        if (0L == l2) {
            throw new GLException("FBConfig null of " + X11GLXGraphicsConfiguration.toHexString((int)n));
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault(x11GraphicsScreen.getDevice());
        }
        if (null == (x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(gLProfile, l, l2, true, true, true, GLXUtil.isMultisampleAvailable(l)))) {
            throw new GLException("GLCapabilities null of " + X11GLXGraphicsConfiguration.toHexString((long)l2));
        }
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, x11GLCapabilities, new DefaultGLCapabilitiesChooser());
    }

    public Object clone() {
        return super.clone();
    }

    public final long getFBConfig() {
        return ((X11GLCapabilities)this.capabilitiesChosen).getFBConfig();
    }

    public final int getFBConfigID() {
        return ((X11GLCapabilities)this.capabilitiesChosen).getFBConfigID();
    }

    void updateGraphicsConfiguration() {
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)this.getScreen().getDevice()).chooseGraphicsConfiguration(this.getChosenCapabilities(), this.getRequestedCapabilities(), (CapabilitiesChooser)this.chooser, this.getScreen());
        if (null != x11GLXGraphicsConfiguration) {
            this.setXVisualInfo(x11GLXGraphicsConfiguration.getXVisualInfo());
            this.setChosenCapabilities(x11GLXGraphicsConfiguration.getChosenCapabilities());
            if (DEBUG) {
                System.err.println("!!! updateGraphicsConfiguration: " + this);
            }
        }
    }

    private static int nonZeroOrDontCare(int n) {
        return n != 0 ? n : -1;
    }

    static int[] GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, boolean bl2, long l, int n) {
        int n2 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        if (n2 < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int[] nArray = new int[128];
        int n3 = 0;
        if (bl) {
            nArray[n3++] = 32784;
            int n4 = gLCapabilitiesImmutable.isOnscreen() ? 1 : (nArray[n3++] = gLCapabilitiesImmutable.isPBuffer() ? 4 : 2);
        }
        if (bl) {
            nArray[n3++] = 32785;
            nArray[n3++] = 1;
        } else {
            nArray[n3++] = 4;
        }
        if (bl) {
            nArray[n3++] = 5;
            nArray[n3++] = gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0;
            nArray[n3++] = 6;
            nArray[n3++] = gLCapabilitiesImmutable.getStereo() ? 1 : 0;
            nArray[n3++] = 35;
            int n5 = nArray[n3++] = gLCapabilitiesImmutable.isBackgroundOpaque() ? 32768 : 32776;
            if (!gLCapabilitiesImmutable.isBackgroundOpaque()) {
                nArray[n3++] = 37;
                nArray[n3++] = gLCapabilitiesImmutable.getTransparentRedValue() >= 0 ? gLCapabilitiesImmutable.getTransparentRedValue() : -1;
                nArray[n3++] = 38;
                nArray[n3++] = gLCapabilitiesImmutable.getTransparentGreenValue() >= 0 ? gLCapabilitiesImmutable.getTransparentGreenValue() : -1;
                nArray[n3++] = 39;
                nArray[n3++] = gLCapabilitiesImmutable.getTransparentBlueValue() >= 0 ? gLCapabilitiesImmutable.getTransparentBlueValue() : -1;
                nArray[n3++] = 40;
                nArray[n3++] = gLCapabilitiesImmutable.getTransparentAlphaValue() >= 0 ? gLCapabilitiesImmutable.getTransparentAlphaValue() : -1;
            }
        } else {
            if (gLCapabilitiesImmutable.getDoubleBuffered()) {
                nArray[n3++] = 5;
            }
            if (gLCapabilitiesImmutable.getStereo()) {
                nArray[n3++] = 6;
            }
        }
        nArray[n3++] = 8;
        nArray[n3++] = gLCapabilitiesImmutable.getRedBits();
        nArray[n3++] = 9;
        nArray[n3++] = gLCapabilitiesImmutable.getGreenBits();
        nArray[n3++] = 10;
        nArray[n3++] = gLCapabilitiesImmutable.getBlueBits();
        nArray[n3++] = 11;
        nArray[n3++] = gLCapabilitiesImmutable.getAlphaBits();
        nArray[n3++] = 12;
        nArray[n3++] = gLCapabilitiesImmutable.getDepthBits();
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            nArray[n3++] = 13;
            nArray[n3++] = gLCapabilitiesImmutable.getStencilBits();
        }
        if (gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0 || gLCapabilitiesImmutable.getAccumAlphaBits() > 0) {
            nArray[n3++] = 14;
            nArray[n3++] = gLCapabilitiesImmutable.getAccumRedBits();
            nArray[n3++] = 15;
            nArray[n3++] = gLCapabilitiesImmutable.getAccumGreenBits();
            nArray[n3++] = 16;
            nArray[n3++] = gLCapabilitiesImmutable.getAccumBlueBits();
            nArray[n3++] = 17;
            nArray[n3++] = gLCapabilitiesImmutable.getAccumAlphaBits();
        }
        if (bl2 && gLCapabilitiesImmutable.getSampleBuffers()) {
            nArray[n3++] = 100000;
            nArray[n3++] = 1;
            nArray[n3++] = 100001;
            nArray[n3++] = gLCapabilitiesImmutable.getNumSamples();
        }
        if (gLCapabilitiesImmutable.isPBuffer() && gLCapabilitiesImmutable.getPbufferFloatingPointBuffers()) {
            String string = GLX.glXQueryExtensionsString(l, n);
            if (string == null || string.indexOf("GLX_NV_float_buffer") < 0) {
                throw new GLException("Floating-point pbuffers on X11 currently require NVidia hardware: " + string);
            }
            nArray[n3++] = 8368;
            nArray[n3++] = 1;
        }
        nArray[n3++] = 0;
        return nArray;
    }

    static boolean GLXFBConfigValid(long l, long l2) {
        int[] nArray = new int[1];
        return 2 != GLX.glXGetFBConfigAttrib(l, l2, 32785, nArray, 0);
    }

    static int FBCfgDrawableTypeBits(long l, long l2) {
        int n = 0;
        int[] nArray = new int[1];
        int n2 = X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 32784, nArray, 0);
        if (0 != (n2 & 1)) {
            n |= 1;
        }
        if (0 != (n2 & 2)) {
            n |= 2;
        }
        if (0 != (n2 & 4)) {
            n |= 4;
        }
        return n;
    }

    static X11GLCapabilities GLXFBConfig2GLCapabilities(GLProfile gLProfile, long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ArrayList arrayList = new ArrayList();
        int n = GLGraphicsConfigurationUtil.getWinAttributeBits(bl2, bl3);
        if (X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, l, l2, n, bl4)) {
            return (X11GLCapabilities)arrayList.get(0);
        }
        if (bl && X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, l, l2, 7, bl4)) {
            return (X11GLCapabilities)arrayList.get(0);
        }
        return null;
    }

    static boolean GLXFBConfig2GLCapabilities(ArrayList arrayList, GLProfile gLProfile, long l, long l2, int n, boolean bl) {
        int n2 = X11GLXGraphicsConfiguration.FBCfgDrawableTypeBits(l, l2);
        int n3 = n & n2;
        int n4 = X11GLXGraphicsConfiguration.glXFBConfig2FBConfigID(l, l2);
        XVisualInfo xVisualInfo = GLX.glXGetVisualFromFBConfig(l, l2);
        if (null == xVisualInfo) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: Null XVisualInfo for FBConfigID 0x" + Integer.toHexString(n4));
            }
            n3 &= 0xFFFFFFFE;
        }
        if (0 == n3) {
            return false;
        }
        int[] nArray = new int[1];
        if (2 == GLX.glXGetFBConfigAttrib(l, l2, 32785, nArray, 0)) {
            return false;
        }
        X11GLCapabilities x11GLCapabilities = new X11GLCapabilities(xVisualInfo, l2, n4, gLProfile);
        x11GLCapabilities.setDoubleBuffered(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 5, nArray, 0) != 0);
        x11GLCapabilities.setStereo(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 6, nArray, 0) != 0);
        x11GLCapabilities.setHardwareAccelerated(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 32, nArray, 0) != 32769);
        x11GLCapabilities.setDepthBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 12, nArray, 0));
        x11GLCapabilities.setStencilBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 13, nArray, 0));
        x11GLCapabilities.setRedBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 8, nArray, 0));
        x11GLCapabilities.setGreenBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 9, nArray, 0));
        x11GLCapabilities.setBlueBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 10, nArray, 0));
        x11GLCapabilities.setAlphaBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 11, nArray, 0));
        x11GLCapabilities.setAccumRedBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 14, nArray, 0));
        x11GLCapabilities.setAccumGreenBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 15, nArray, 0));
        x11GLCapabilities.setAccumBlueBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 16, nArray, 0));
        x11GLCapabilities.setAccumAlphaBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 17, nArray, 0));
        if (bl) {
            x11GLCapabilities.setSampleBuffers(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 100000, nArray, 0) != 0);
            x11GLCapabilities.setNumSamples(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 100001, nArray, 0));
        }
        x11GLCapabilities.setBackgroundOpaque(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 35, nArray, 0) == 32768);
        if (!x11GLCapabilities.isBackgroundOpaque()) {
            X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 37, nArray, 0);
            x11GLCapabilities.setTransparentRedValue((long)nArray[0] == -1L ? -1 : nArray[0]);
            X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 38, nArray, 0);
            x11GLCapabilities.setTransparentGreenValue((long)nArray[0] == -1L ? -1 : nArray[0]);
            X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 39, nArray, 0);
            x11GLCapabilities.setTransparentBlueValue((long)nArray[0] == -1L ? -1 : nArray[0]);
            X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 40, nArray, 0);
            x11GLCapabilities.setTransparentAlphaValue((long)nArray[0] == -1L ? -1 : nArray[0]);
        }
        try {
            x11GLCapabilities.setPbufferFloatingPointBuffers(X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 8368, nArray, 0) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return GLGraphicsConfigurationUtil.addGLCapabilitiesPermutations(arrayList, x11GLCapabilities, n3);
    }

    private static String glXGetFBConfigErrorCode(int n) {
        switch (n) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
        }
        return "Unknown error code " + n;
    }

    static int glXGetFBConfig(long l, long l2, int n, int[] nArray, int n2) {
        if (l == 0L) {
            throw new GLException("No display connection");
        }
        int n3 = GLX.glXGetFBConfigAttrib(l, l2, n, nArray, n2);
        if (n3 != 0) {
            throw new GLException("glXGetFBConfig(" + X11GLXGraphicsConfiguration.toHexString((int)n) + ") failed: error code " + X11GLXGraphicsConfiguration.glXGetFBConfigErrorCode(n3));
        }
        return nArray[n2];
    }

    static int glXFBConfig2FBConfigID(long l, long l2) {
        int[] nArray = new int[1];
        return X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 32787, nArray, 0);
    }

    static long glXFBConfigID2FBConfig(long l, int n, int n2) {
        int[] nArray = new int[]{32787, n2, 0};
        int[] nArray2 = new int[]{-1};
        PointerBuffer pointerBuffer = GLX.glXChooseFBConfig(l, n, nArray, 0, nArray2, 0);
        if (pointerBuffer == null || pointerBuffer.limit() < 1) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    static XVisualInfo XVisualID2XVisualInfo(long l, long l2) {
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setVisualid(l2);
        XVisualInfo[] xVisualInfoArray = X11Util.XGetVisualInfo((long)l, (long)1L, (XVisualInfo)xVisualInfo, (int[])nArray, (int)0);
        if (xVisualInfoArray == null || xVisualInfoArray.length == 0) {
            return null;
        }
        XVisualInfo xVisualInfo2 = XVisualInfo.create((XVisualInfo)xVisualInfoArray[0]);
        if (DEBUG) {
            System.err.println("!!! Fetched XVisualInfo for visual ID " + X11GLXGraphicsConfiguration.toHexString((long)l2));
            System.err.println("!!! Resulting XVisualInfo: visualid = " + X11GLXGraphicsConfiguration.toHexString((long)xVisualInfo2.getVisualid()));
        }
        return xVisualInfo2;
    }

    static boolean XVisualInfo2GLCapabilities(ArrayList arrayList, GLProfile gLProfile, long l, XVisualInfo xVisualInfo, int n, boolean bl) {
        int n2 = n & 3;
        if (0 == n2) {
            return false;
        }
        int[] nArray = new int[1];
        int n3 = X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 1, nArray, 0);
        if (n3 == 0) {
            if (DEBUG) {
                System.err.println("Visual (" + X11GLXGraphicsConfiguration.toHexString((long)xVisualInfo.getVisualid()) + ") does not support OpenGL");
            }
            return false;
        }
        n3 = X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 4, nArray, 0);
        if (n3 == 0) {
            if (DEBUG) {
                System.err.println("Visual (" + X11GLXGraphicsConfiguration.toHexString((long)xVisualInfo.getVisualid()) + ") does not support RGBA");
            }
            return false;
        }
        X11GLCapabilities x11GLCapabilities = new X11GLCapabilities(xVisualInfo, gLProfile);
        x11GLCapabilities.setDoubleBuffered(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 5, nArray, 0) != 0);
        x11GLCapabilities.setStereo(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 6, nArray, 0) != 0);
        x11GLCapabilities.setHardwareAccelerated(true);
        x11GLCapabilities.setDepthBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 12, nArray, 0));
        x11GLCapabilities.setStencilBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 13, nArray, 0));
        x11GLCapabilities.setRedBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 8, nArray, 0));
        x11GLCapabilities.setGreenBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 9, nArray, 0));
        x11GLCapabilities.setBlueBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 10, nArray, 0));
        x11GLCapabilities.setAlphaBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 11, nArray, 0));
        x11GLCapabilities.setAccumRedBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 14, nArray, 0));
        x11GLCapabilities.setAccumGreenBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 15, nArray, 0));
        x11GLCapabilities.setAccumBlueBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 16, nArray, 0));
        x11GLCapabilities.setAccumAlphaBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 17, nArray, 0));
        if (bl) {
            x11GLCapabilities.setSampleBuffers(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 100000, nArray, 0) != 0);
            x11GLCapabilities.setNumSamples(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 100001, nArray, 0));
        }
        return GLGraphicsConfigurationUtil.addGLCapabilitiesPermutations(arrayList, x11GLCapabilities, n2);
    }

    private static String glXGetConfigErrorCode(int n) {
        switch (n) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 1: {
                return "GLX_BAD_SCREEN";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
            case 4: {
                return "GLX_BAD_VISUAL";
            }
        }
        return "Unknown error code " + n;
    }

    static int glXGetConfig(long l, XVisualInfo xVisualInfo, int n, int[] nArray, int n2) {
        if (l == 0L) {
            throw new GLException("No display connection");
        }
        int n3 = GLX.glXGetConfig(l, xVisualInfo, n, nArray, n2);
        if (n3 != 0) {
            throw new GLException("glXGetConfig(" + X11GLXGraphicsConfiguration.toHexString((int)n) + ") failed: error code " + X11GLXGraphicsConfiguration.glXGetConfigErrorCode(n3));
        }
        return nArray[n2];
    }

    public String toString() {
        return "X11GLXGraphicsConfiguration[" + this.getScreen() + ", visualID " + X11GLXGraphicsConfiguration.toHexString((long)this.getVisualID()) + ", fbConfigID " + X11GLXGraphicsConfiguration.toHexString((int)this.getFBConfigID()) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

