/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.PointerBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Util;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.Debug;
import jogamp.opengl.GLGraphicsConfigurationFactory;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11GLCapabilities;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11GLXGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactory {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    static X11GLCapabilities.XVisualIDComparator XVisualIDComparator = new X11GLCapabilities.XVisualIDComparator();

    X11GLXGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (!(abstractGraphicsScreen instanceof X11GraphicsScreen)) {
            throw new IllegalArgumentException("Only X11GraphicsScreen are allowed here");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        return X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, (X11GraphicsScreen)abstractGraphicsScreen);
    }

    protected static List getAvailableCapabilities(X11GLXDrawableFactory x11GLXDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        X11GLXDrawableFactory.SharedResource sharedResource = x11GLXDrawableFactory.getOrCreateSharedResource(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        X11GraphicsScreen x11GraphicsScreen = (X11GraphicsScreen)sharedResource.getScreen();
        X11GLXDrawable x11GLXDrawable = (X11GLXDrawable)sharedResource.getDrawable();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = x11GLXDrawable.getChosenGLCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        List list = null;
        if (sharedResource.isGLXVersionGreaterEqualOneThree()) {
            list = X11GLXGraphicsConfigurationFactory.getAvailableGLCapabilitiesFBConfig(x11GraphicsScreen, gLProfile);
        }
        if (null == list || 0 == list.size()) {
            list = X11GLXGraphicsConfigurationFactory.getAvailableGLCapabilitiesXVisual(x11GraphicsScreen, gLProfile);
        }
        if (null != list) {
            Collections.sort(list, XVisualIDComparator);
        }
        return list;
    }

    static List getAvailableGLCapabilitiesFBConfig(X11GraphicsScreen x11GraphicsScreen, GLProfile gLProfile) {
        PointerBuffer pointerBuffer = null;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n = x11GraphicsScreen.getIndex();
        boolean bl = GLXUtil.isMultisampleAvailable(l);
        int[] nArray = new int[]{-1};
        ArrayList arrayList = new ArrayList();
        pointerBuffer = GLX.glXChooseFBConfig(l, n, null, 0, nArray, 0);
        if (pointerBuffer == null || pointerBuffer.limit() <= 0) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesFBConfig: Failed glXChooseFBConfig (" + x11GraphicsScreen + "): " + pointerBuffer + ", " + nArray[0]);
            }
            return null;
        }
        for (int i = 0; i < pointerBuffer.limit(); ++i) {
            if (X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, l, pointerBuffer.get(i), 7, bl) || !DEBUG) continue;
            System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesFBConfig: FBConfig invalid (2): (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(i)));
        }
        return arrayList;
    }

    static List getAvailableGLCapabilitiesXVisual(X11GraphicsScreen x11GraphicsScreen, GLProfile gLProfile) {
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n = x11GraphicsScreen.getIndex();
        boolean bl = GLXUtil.isMultisampleAvailable(l);
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setScreen(n);
        XVisualInfo[] xVisualInfoArray = X11Util.XGetVisualInfo((long)l, (long)2L, (XVisualInfo)xVisualInfo, (int[])nArray, (int)0);
        if (xVisualInfoArray == null || xVisualInfoArray.length < 1) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < xVisualInfoArray.length; ++i) {
            if (X11GLXGraphicsConfiguration.XVisualInfo2GLCapabilities(arrayList, gLProfile, l, xVisualInfoArray[i], 7, bl) || !DEBUG) continue;
            System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesXVisual: XVisual invalid: (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)xVisualInfoArray[i].getVisualid()));
        }
        return arrayList;
    }

    static X11GLXGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen) {
        if (x11GraphicsScreen == null) {
            throw new IllegalArgumentException("AbstractGraphicsScreen is null");
        }
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory();
        gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, x11GLXDrawableFactory.canCreateGLPbuffer((AbstractGraphicsDevice)x11GraphicsDevice));
        boolean bl = gLCapabilitiesImmutable.isPBuffer();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = null;
        if (x11GLXDrawableFactory.isGLXVersionGreaterEqualOneThree((AbstractGraphicsDevice)x11GraphicsDevice)) {
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationFBConfig(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen);
        }
        if (null == x11GLXGraphicsConfiguration) {
            if (bl) {
                throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig for " + gLCapabilitiesImmutable);
            }
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationXVisual(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen);
        }
        if (null == x11GLXGraphicsConfiguration) {
            throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig and XVisual for " + gLCapabilitiesImmutable);
        }
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationStatic(" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + x11GLXGraphicsConfiguration);
        }
        return x11GLXGraphicsConfiguration;
    }

    static X11GLXGraphicsConfiguration fetchGraphicsConfigurationFBConfig(X11GraphicsScreen x11GraphicsScreen, int n, GLProfile gLProfile) {
        int n2;
        long l;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l2 = abstractGraphicsDevice.getHandle();
        if (!X11GLXGraphicsConfiguration.GLXFBConfigValid(l2, l = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l2, n2 = x11GraphicsScreen.getIndex(), n))) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed - GLX FBConfig invalid: (" + x11GraphicsScreen + "," + X11GLXGraphicsConfigurationFactory.toHexString((int)n) + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)l));
            }
            return null;
        }
        X11GLCapabilities x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(gLProfile, l2, l, true, true, true, GLXUtil.isMultisampleAvailable(l2));
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, x11GLCapabilities, new DefaultGLCapabilitiesChooser());
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationFBConfig(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen) {
        int n;
        long l = -1L;
        int n2 = -1;
        PointerBuffer pointerBuffer = null;
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl = gLCapabilitiesImmutable.isOnscreen();
        boolean bl2 = gLCapabilitiesImmutable.isPBuffer();
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l2 = abstractGraphicsDevice.getHandle();
        int n3 = x11GraphicsScreen.getIndex();
        boolean bl3 = GLXUtil.isMultisampleAvailable(l2);
        int[] nArray = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, true, bl3, l2, n3);
        int[] nArray2 = new int[]{-1};
        ArrayList arrayList = new ArrayList();
        int n4 = GLGraphicsConfigurationUtil.getWinAttributeBits(bl, bl2);
        pointerBuffer = GLX.glXChooseFBConfig(l2, n3, nArray, 0, nArray2, 0);
        if (pointerBuffer != null && pointerBuffer.limit() > 0) {
            for (n = 0; n < pointerBuffer.limit(); ++n) {
                if (X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, l2, pointerBuffer.get(n), n4, bl3) || !DEBUG) continue;
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: FBConfig invalid (1): (" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(n)));
            }
            if (arrayList.size() > 0) {
                l = pointerBuffer.get(0);
                n2 = 0;
                if (DEBUG) {
                    System.err.println("!!! glXChooseFBConfig recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString((long)l) + ", idx " + n2);
                    System.err.println("!!! user  caps " + gLCapabilitiesImmutable);
                    System.err.println("!!! fbcfg caps " + arrayList.get(n2));
                }
            } else if (DEBUG) {
                System.err.println("!!! glXChooseFBConfig no caps for recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(0)));
                System.err.println("!!! user  caps " + gLCapabilitiesImmutable);
            }
        }
        if (0 == arrayList.size()) {
            l = -1L;
            n2 = -1;
            pointerBuffer = GLX.glXChooseFBConfig(l2, n3, null, 0, nArray2, 0);
            if (pointerBuffer == null || pointerBuffer.limit() <= 0) {
                if (DEBUG) {
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed glXChooseFBConfig (" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + pointerBuffer + ", " + nArray2[0]);
                }
                return null;
            }
            for (n = 0; n < pointerBuffer.limit(); ++n) {
                if (X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(arrayList, gLProfile, l2, pointerBuffer.get(n), n4, bl3) || !DEBUG) continue;
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: FBConfig invalid (2): (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)pointerBuffer.get(n)));
            }
        }
        if (0 > (n = X11GLXGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, arrayList, n2))) {
            if (DEBUG) {
                Thread.dumpStack();
            }
            return null;
        }
        X11GLCapabilities x11GLCapabilities = (X11GLCapabilities)arrayList.get(n);
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationXVisual(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen) {
        int n;
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int n2 = GLGraphicsConfigurationUtil.getWinAttributeBits(gLCapabilitiesImmutable.isOnscreen(), false);
        ArrayList arrayList = new ArrayList();
        int n3 = -1;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n4 = x11GraphicsScreen.getIndex();
        boolean bl = GLXUtil.isMultisampleAvailable(l);
        int[] nArray = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, false, bl, l, n4);
        XVisualInfo xVisualInfo = GLX.glXChooseVisual(l, n4, nArray, 0);
        if (DEBUG) {
            System.err.print("!!! glXChooseVisual recommended ");
            if (xVisualInfo == null) {
                System.err.println("null visual");
            } else {
                System.err.println("visual id " + X11GLXGraphicsConfigurationFactory.toHexString((long)xVisualInfo.getVisualid()));
            }
        }
        int[] nArray2 = new int[1];
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.setScreen(n4);
        XVisualInfo[] xVisualInfoArray = X11Util.XGetVisualInfo((long)l, (long)2L, (XVisualInfo)xVisualInfo2, (int[])nArray2, (int)0);
        if (xVisualInfoArray == null || xVisualInfoArray.length < 1) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        for (n = 0; n < xVisualInfoArray.length; ++n) {
            if (!X11GLXGraphicsConfiguration.XVisualInfo2GLCapabilities(arrayList, gLProfile, l, xVisualInfoArray[n], n2, bl)) {
                if (!DEBUG) continue;
                System.err.println("X11GLXGraphicsConfiguration.getAvailableGLCapabilitiesXVisual: XVisual invalid: (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString((long)xVisualInfoArray[n].getVisualid()));
                continue;
            }
            if (xVisualInfo == null || xVisualInfo.getVisualid() != xVisualInfoArray[n].getVisualid()) continue;
            n3 = arrayList.size() - 1;
        }
        n = X11GLXGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, arrayList, n3);
        if (0 > n) {
            if (DEBUG) {
                Thread.dumpStack();
            }
            return null;
        }
        X11GLCapabilities x11GLCapabilities = (X11GLCapabilities)arrayList.get(n);
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, gLCapabilitiesImmutable2, gLCapabilitiesChooser);
    }
}

