/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.CodingMode;
import com.fluendo.jheora.Playback;
import com.fluendo.jheora.Recon;
import com.fluendo.jheora.iDCT;
import com.fluendo.utils.MemUtils;

public class DCTDecode {
    private static final int PUR = 8;
    private static final int PU = 4;
    private static final int PUL = 2;
    private static final int PL = 1;
    private short[] dequant_matrix = new short[64];
    private static final int[] ModeUsesMC = new int[]{0, 0, 1, 1, 1, 0, 1, 1};
    private static final short[][] pc = new short[][]{{0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 1, 1}, {0, 1, 0, 0, 0, 0}, {29, -26, 29, 0, 5, 31}, {1, 0, 0, 0, 0, 0}, {75, 53, 0, 0, 7, 127}, {1, 1, 0, 0, 1, 1}, {75, 0, 53, 0, 7, 127}, {1, 0, 0, 0, 0, 0}, {75, 0, 53, 0, 7, 127}, {3, 10, 3, 0, 4, 15}, {29, -26, 29, 0, 5, 31}};
    private static final int[] bc_mask = new int[]{15, 12, 1, 0, 7, 4, 1, 0};
    private static final short[] Mode2Frame = new short[]{1, 0, 1, 1, 1, 2, 2, 1};
    private short[] ReconDataBuffer = new short[64];
    private int[] v = new int[4];
    private int[] fn = new int[4];
    private short[] Last = new short[3];
    private iDCT idct = new iDCT();

    private void ExpandKFBlock(Playback pbi, int FragmentNumber) {
        short[] dequant_coeffs;
        int ReconPixelsPerLine;
        byte qi = pbi.FragQs[FragmentNumber];
        if (FragmentNumber < pbi.YPlaneFragments) {
            ReconPixelsPerLine = pbi.YStride;
            dequant_coeffs = pbi.info.dequant_tables[0][0][pbi.frameQIS[qi]];
            this.dequant_matrix[0] = pbi.info.dequant_tables[0][0][pbi.frameQIS[0]][0];
        } else if (FragmentNumber < pbi.YPlaneFragments + pbi.UVPlaneFragments) {
            ReconPixelsPerLine = pbi.UVStride;
            dequant_coeffs = pbi.info.dequant_tables[0][1][pbi.frameQIS[qi]];
            this.dequant_matrix[0] = pbi.info.dequant_tables[0][1][pbi.frameQIS[0]][0];
        } else {
            ReconPixelsPerLine = pbi.UVStride;
            dequant_coeffs = pbi.info.dequant_tables[0][2][pbi.frameQIS[qi]];
            this.dequant_matrix[0] = pbi.info.dequant_tables[0][2][pbi.frameQIS[0]][0];
        }
        System.arraycopy(dequant_coeffs, 1, this.dequant_matrix, 1, 63);
        short[] quantized_list = pbi.QFragData[FragmentNumber];
        switch (pbi.FragCoefEOB[FragmentNumber]) {
            case 0: 
            case 1: {
                this.idct.IDct1(quantized_list, this.dequant_matrix, this.ReconDataBuffer);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.idct.IDct10(quantized_list, this.dequant_matrix, this.ReconDataBuffer);
                break;
            }
            default: {
                this.idct.IDctSlow(quantized_list, this.dequant_matrix, this.ReconDataBuffer);
            }
        }
        int ReconPixelIndex = pbi.recon_pixel_index_table[FragmentNumber];
        Recon.ReconIntra(pbi.ThisFrameRecon, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
    }

    private void ExpandBlock(Playback pbi, int FragmentNumber) {
        short[] dequant_coeffs;
        int MvModMaskX;
        int MvModMaskY;
        int MvShiftX;
        int MvShiftY;
        int ReconPixelsPerLine;
        byte qi = pbi.FragQs[FragmentNumber];
        CodingMode codingMode = pbi.getFrameType() == 0 ? CodingMode.CODE_INTRA : pbi.FragCodingMethod[FragmentNumber];
        if (FragmentNumber < pbi.YPlaneFragments) {
            ReconPixelsPerLine = pbi.YStride;
            MvShiftY = 1;
            MvShiftX = 1;
            MvModMaskY = 1;
            MvModMaskX = 1;
            if (codingMode == CodingMode.CODE_INTRA) {
                dequant_coeffs = pbi.info.dequant_tables[0][0][pbi.frameQIS[qi]];
                this.dequant_matrix[0] = pbi.info.dequant_tables[0][0][pbi.frameQIS[0]][0];
            } else {
                dequant_coeffs = pbi.info.dequant_tables[1][0][pbi.frameQIS[qi]];
                this.dequant_matrix[0] = pbi.info.dequant_tables[1][0][pbi.frameQIS[0]][0];
            }
        } else {
            ReconPixelsPerLine = pbi.UVStride;
            MvShiftX = pbi.UVShiftX + 1;
            MvShiftY = pbi.UVShiftY + 1;
            MvModMaskY = 3;
            MvModMaskX = 3;
            if (MvShiftX == 1) {
                MvModMaskX = 1;
            }
            if (MvShiftY == 1) {
                MvModMaskY = 1;
            }
            if (FragmentNumber < pbi.YPlaneFragments + pbi.UVPlaneFragments) {
                if (codingMode == CodingMode.CODE_INTRA) {
                    dequant_coeffs = pbi.info.dequant_tables[0][1][pbi.frameQIS[qi]];
                    this.dequant_matrix[0] = pbi.info.dequant_tables[0][1][pbi.frameQIS[0]][0];
                } else {
                    dequant_coeffs = pbi.info.dequant_tables[1][1][pbi.frameQIS[qi]];
                    this.dequant_matrix[0] = pbi.info.dequant_tables[1][1][pbi.frameQIS[0]][0];
                }
            } else if (codingMode == CodingMode.CODE_INTRA) {
                dequant_coeffs = pbi.info.dequant_tables[0][2][pbi.frameQIS[qi]];
                this.dequant_matrix[0] = pbi.info.dequant_tables[0][2][pbi.frameQIS[0]][0];
            } else {
                dequant_coeffs = pbi.info.dequant_tables[1][2][pbi.frameQIS[qi]];
                this.dequant_matrix[0] = pbi.info.dequant_tables[1][2][pbi.frameQIS[0]][0];
            }
        }
        System.arraycopy(dequant_coeffs, 1, this.dequant_matrix, 1, 63);
        short[] quantized_list = pbi.QFragData[FragmentNumber];
        switch (pbi.FragCoefEOB[FragmentNumber]) {
            case 0: 
            case 1: {
                this.idct.IDct1(quantized_list, this.dequant_matrix, this.ReconDataBuffer);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.idct.IDct10(quantized_list, this.dequant_matrix, this.ReconDataBuffer);
                break;
            }
            default: {
                this.idct.IDctSlow(quantized_list, this.dequant_matrix, this.ReconDataBuffer);
            }
        }
        int ReconPixelIndex = pbi.recon_pixel_index_table[FragmentNumber];
        if (codingMode == CodingMode.CODE_INTER_NO_MV) {
            Recon.ReconInter(pbi.ThisFrameRecon, ReconPixelIndex, pbi.LastFrameRecon, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
        } else if (ModeUsesMC[codingMode.getValue()] != 0) {
            int ReconPtr2Offset = 0;
            int MVOffset = 0;
            int dir = pbi.FragMVect[FragmentNumber].x;
            if (dir > 0) {
                MVOffset = dir >> MvShiftX;
                if ((dir & MvModMaskX) != 0) {
                    ReconPtr2Offset = 1;
                }
            } else if (dir < 0) {
                MVOffset = -(-dir >> MvShiftX);
                if ((-dir & MvModMaskX) != 0) {
                    ReconPtr2Offset = -1;
                }
            }
            if ((dir = pbi.FragMVect[FragmentNumber].y) > 0) {
                MVOffset += (dir >> MvShiftY) * ReconPixelsPerLine;
                if ((dir & MvModMaskY) != 0) {
                    ReconPtr2Offset += ReconPixelsPerLine;
                }
            } else if (dir < 0) {
                MVOffset -= (-dir >> MvShiftY) * ReconPixelsPerLine;
                if ((-dir & MvModMaskY) != 0) {
                    ReconPtr2Offset -= ReconPixelsPerLine;
                }
            }
            int LastFrameRecOffset = ReconPixelIndex + MVOffset;
            short[] LastFrameRecPtr = codingMode == CodingMode.CODE_GOLDEN_MV ? pbi.GoldenFrame : pbi.LastFrameRecon;
            if (ReconPtr2Offset == 0) {
                Recon.ReconInter(pbi.ThisFrameRecon, ReconPixelIndex, LastFrameRecPtr, LastFrameRecOffset, this.ReconDataBuffer, ReconPixelsPerLine);
            } else {
                Recon.ReconInterHalfPixel2(pbi.ThisFrameRecon, ReconPixelIndex, LastFrameRecPtr, LastFrameRecOffset, LastFrameRecPtr, LastFrameRecOffset + ReconPtr2Offset, this.ReconDataBuffer, ReconPixelsPerLine);
            }
        } else if (codingMode == CodingMode.CODE_USING_GOLDEN) {
            Recon.ReconInter(pbi.ThisFrameRecon, ReconPixelIndex, pbi.GoldenFrame, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
        } else {
            Recon.ReconIntra(pbi.ThisFrameRecon, ReconPixelIndex, this.ReconDataBuffer, ReconPixelsPerLine);
        }
    }

    private void UpdateUMV_HBorders(Playback pbi, short[] DestReconPtr, int PlaneFragOffset) {
        int LineFragments;
        int PlaneFragments;
        int PlaneBorderHeight;
        int PlaneBorderWidth;
        int PlaneStride;
        int BlockVStep;
        if (PlaneFragOffset == 0) {
            BlockVStep = pbi.YStride * 7;
            PlaneStride = pbi.YStride;
            PlaneBorderWidth = 16;
            PlaneBorderHeight = 16;
            PlaneFragments = pbi.YPlaneFragments;
            LineFragments = pbi.HFragments;
        } else {
            BlockVStep = pbi.UVStride * 7;
            PlaneStride = pbi.UVStride;
            PlaneBorderWidth = 16 >> pbi.UVShiftX;
            PlaneBorderHeight = 16 >> pbi.UVShiftY;
            PlaneFragments = pbi.UVPlaneFragments;
            LineFragments = pbi.HFragments >> pbi.UVShiftX;
        }
        int PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset];
        short[] SrcPtr1 = DestReconPtr;
        int SrcOff1 = PixelIndex - PlaneBorderWidth;
        short[] DestPtr1 = SrcPtr1;
        int DestOff1 = SrcOff1 - PlaneBorderHeight * PlaneStride;
        PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset + PlaneFragments - LineFragments] + BlockVStep;
        short[] SrcPtr2 = DestReconPtr;
        int SrcOff2 = PixelIndex - PlaneBorderWidth;
        short[] DestPtr2 = SrcPtr2;
        int DestOff2 = SrcOff2 + PlaneStride;
        for (int i = 0; i < PlaneBorderHeight; ++i) {
            System.arraycopy(SrcPtr1, SrcOff1, DestPtr1, DestOff1, PlaneStride);
            System.arraycopy(SrcPtr2, SrcOff2, DestPtr2, DestOff2, PlaneStride);
            DestOff1 += PlaneStride;
            DestOff2 += PlaneStride;
        }
    }

    private void UpdateUMV_VBorders(Playback pbi, short[] DestReconPtr, int PlaneFragOffset) {
        int PlaneHeight;
        int LineFragments;
        int PlaneBorderWidth;
        int PlaneStride;
        if (PlaneFragOffset == 0) {
            PlaneStride = pbi.YStride;
            PlaneBorderWidth = 16;
            LineFragments = pbi.HFragments;
            PlaneHeight = pbi.info.height;
        } else {
            PlaneStride = pbi.UVStride;
            PlaneBorderWidth = 16 >> pbi.UVShiftX;
            LineFragments = pbi.HFragments >> pbi.UVShiftX;
            PlaneHeight = pbi.info.height >> pbi.UVShiftY;
        }
        int PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset];
        short[] SrcPtr1 = DestReconPtr;
        int SrcOff1 = PixelIndex;
        short[] DestPtr1 = DestReconPtr;
        int DestOff1 = PixelIndex - PlaneBorderWidth;
        PixelIndex = pbi.recon_pixel_index_table[PlaneFragOffset + LineFragments - 1] + 7;
        short[] SrcPtr2 = DestReconPtr;
        int SrcOff2 = PixelIndex;
        short[] DestPtr2 = DestReconPtr;
        int DestOff2 = PixelIndex + 1;
        for (int i = 0; i < PlaneHeight; ++i) {
            MemUtils.set(DestPtr1, DestOff1, (int)SrcPtr1[SrcOff1], PlaneBorderWidth);
            MemUtils.set(DestPtr2, DestOff2, (int)SrcPtr2[SrcOff2], PlaneBorderWidth);
            DestOff1 += PlaneStride;
            DestOff2 += PlaneStride;
            SrcOff1 += PlaneStride;
            SrcOff2 += PlaneStride;
        }
    }

    private void UpdateUMVBorder(Playback pbi, short[] DestReconPtr) {
        int PlaneFragOffset = 0;
        this.UpdateUMV_VBorders(pbi, DestReconPtr, PlaneFragOffset);
        this.UpdateUMV_HBorders(pbi, DestReconPtr, PlaneFragOffset);
        PlaneFragOffset = pbi.YPlaneFragments;
        this.UpdateUMV_VBorders(pbi, DestReconPtr, PlaneFragOffset);
        this.UpdateUMV_HBorders(pbi, DestReconPtr, PlaneFragOffset);
        PlaneFragOffset = pbi.YPlaneFragments + pbi.UVPlaneFragments;
        this.UpdateUMV_VBorders(pbi, DestReconPtr, PlaneFragOffset);
        this.UpdateUMV_HBorders(pbi, DestReconPtr, PlaneFragOffset);
    }

    private void CopyRecon(Playback pbi, short[] DestReconPtr, short[] SrcReconPtr) {
        int PixelIndex;
        int i;
        int PlaneLineStep = pbi.YStride;
        for (i = 0; i < pbi.YPlaneFragments; ++i) {
            if (pbi.display_fragments[i] == 0) continue;
            PixelIndex = pbi.recon_pixel_index_table[i];
            Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
        }
        PlaneLineStep = pbi.UVStride;
        for (i = pbi.YPlaneFragments; i < pbi.UnitFragments; ++i) {
            if (pbi.display_fragments[i] == 0) continue;
            PixelIndex = pbi.recon_pixel_index_table[i];
            Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
        }
    }

    private void CopyNotRecon(Playback pbi, short[] DestReconPtr, short[] SrcReconPtr) {
        int PixelIndex;
        int i;
        int PlaneLineStep = pbi.YStride;
        for (i = 0; i < pbi.YPlaneFragments; ++i) {
            if (pbi.display_fragments[i] != 0) continue;
            PixelIndex = pbi.recon_pixel_index_table[i];
            Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
        }
        PlaneLineStep = pbi.UVStride;
        for (i = pbi.YPlaneFragments; i < pbi.UnitFragments; ++i) {
            if (pbi.display_fragments[i] != 0) continue;
            PixelIndex = pbi.recon_pixel_index_table[i];
            Recon.CopyBlock(SrcReconPtr, DestReconPtr, PixelIndex, PlaneLineStep);
        }
    }

    public void ExpandToken(short[] ExpandedBlock, byte[] CoeffIndex, int FragIndex, int Token, int ExtraBits) {
        if (Token >= 23) {
            if (Token < 30) {
                if (Token < 28) {
                    int n = FragIndex;
                    CoeffIndex[n] = (byte)(CoeffIndex[n] + (byte)(Token - 23 + 1));
                    ExpandedBlock[CoeffIndex[FragIndex]] = (short)(-(((ExtraBits & 1) << 1) - 1));
                } else if (Token == 28) {
                    int n = FragIndex;
                    CoeffIndex[n] = (byte)(CoeffIndex[n] + (6 + (ExtraBits & 3)));
                    ExpandedBlock[CoeffIndex[FragIndex]] = (short)(-(((ExtraBits & 4) >> 1) - 1));
                } else {
                    int n = FragIndex;
                    CoeffIndex[n] = (byte)(CoeffIndex[n] + (10 + (ExtraBits & 7)));
                    ExpandedBlock[CoeffIndex[FragIndex]] = (short)(-(((ExtraBits & 8) >> 2) - 1));
                }
            } else if (Token == 30) {
                int n = FragIndex;
                CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((2 + (ExtraBits & 1)) * -((ExtraBits & 2) - 1));
            } else {
                int n = FragIndex;
                CoeffIndex[n] = (byte)(CoeffIndex[n] + (2 + (ExtraBits & 1)));
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((2 + ((ExtraBits & 2) >> 1)) * -(((ExtraBits & 4) >> 1) - 1));
            }
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
        } else if (Token == 7) {
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + (ExtraBits + 1));
        } else if (Token == 8) {
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + (ExtraBits + 1));
        } else if (Token < 13) {
            switch (Token) {
                case 9: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = 1;
                    break;
                }
                case 10: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = -1;
                    break;
                }
                case 11: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = 2;
                    break;
                }
                case 12: {
                    ExpandedBlock[CoeffIndex[FragIndex]] = -2;
                }
            }
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
        } else {
            if (Token < 17) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)(((Token -= 13) + 3) * -((ExtraBits << 1) - 1));
            } else if (Token == 17) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((7 + (ExtraBits & 1)) * -((ExtraBits & 2) - 1));
            } else if (Token == 18) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((9 + (ExtraBits & 3)) * -(((ExtraBits & 4) >> 1) - 1));
            } else if (Token == 19) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((13 + (ExtraBits & 7)) * -(((ExtraBits & 8) >> 2) - 1));
            } else if (Token == 20) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((21 + (ExtraBits & 0xF)) * -(((ExtraBits & 0x10) >> 3) - 1));
            } else if (Token == 21) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((37 + (ExtraBits & 0x1F)) * -(((ExtraBits & 0x20) >> 4) - 1));
            } else if (Token == 22) {
                ExpandedBlock[CoeffIndex[FragIndex]] = (short)((69 + (ExtraBits & 0x1FF)) * -(((ExtraBits & 0x200) >> 8) - 1));
            }
            int n = FragIndex;
            CoeffIndex[n] = (byte)(CoeffIndex[n] + 1);
        }
    }

    public void ReconRefFrames(Playback pbi) {
        int FragsAcross = pbi.HFragments;
        int FragsDown = pbi.VFragments;
        boolean isBaseFrame = pbi.getFrameType() == 0;
        pbi.filter.SetupLoopFilter(pbi.FrameQIndex);
        for (int j = 0; j < 3; ++j) {
            int k;
            int FromFragment;
            switch (j) {
                case 0: {
                    FromFragment = 0;
                    FragsAcross = pbi.HFragments;
                    FragsDown = pbi.VFragments;
                    break;
                }
                case 1: {
                    FromFragment = pbi.YPlaneFragments;
                    FragsAcross = pbi.HFragments >> pbi.UVShiftX;
                    FragsDown = pbi.VFragments >> pbi.UVShiftY;
                    break;
                }
                default: {
                    FromFragment = pbi.YPlaneFragments + pbi.UVPlaneFragments;
                    FragsAcross = pbi.HFragments >> pbi.UVShiftX;
                    FragsDown = pbi.VFragments >> pbi.UVShiftY;
                }
            }
            for (k = 0; k < 3; ++k) {
                this.Last[k] = 0;
            }
            int i = FromFragment;
            for (int m = 0; m < FragsDown; ++m) {
                int n = 0;
                while (n < FragsAcross) {
                    if (pbi.display_fragments[i] != 0 || pbi.getFrameType() == 0) {
                        short WhichFrame = Mode2Frame[pbi.FragCodingMethod[i].getValue()];
                        int WhichCase = (n == 0 ? 1 : 0) + ((m == 0 ? 1 : 0) << 1) + ((n + 1 == FragsAcross ? 1 : 0) << 2);
                        this.fn[0] = i - 1;
                        this.fn[1] = i - FragsAcross - 1;
                        this.fn[2] = i - FragsAcross;
                        this.fn[3] = i - FragsAcross + 1;
                        int wpc = 0;
                        int pcount = 0;
                        for (k = 0; k < 4; ++k) {
                            int pflag = 1 << k;
                            if ((bc_mask[WhichCase] & pflag) == 0 || pbi.display_fragments[this.fn[k]] == 0 || Mode2Frame[pbi.FragCodingMethod[this.fn[k]].getValue()] != WhichFrame) continue;
                            this.v[pcount] = pbi.QFragData[this.fn[k]][0];
                            wpc = (short)(wpc | pflag);
                            ++pcount;
                        }
                        if (wpc == 0) {
                            short[] sArray = pbi.QFragData[i];
                            sArray[0] = (short)(sArray[0] + this.Last[WhichFrame]);
                        } else {
                            short PredictedDC = (short)(pc[wpc][0] * this.v[0]);
                            for (k = 1; k < pcount; ++k) {
                                PredictedDC = (short)(PredictedDC + pc[wpc][k] * this.v[k]);
                            }
                            if (pc[wpc][4] != 0) {
                                if (PredictedDC < 0) {
                                    PredictedDC = (short)(PredictedDC + pc[wpc][5]);
                                }
                                PredictedDC = (short)(PredictedDC >> pc[wpc][4]);
                            }
                            if ((wpc & 7) == 7) {
                                if (Math.abs(PredictedDC - this.v[2]) > 128) {
                                    PredictedDC = (short)this.v[2];
                                } else if (Math.abs(PredictedDC - this.v[0]) > 128) {
                                    PredictedDC = (short)this.v[0];
                                } else if (Math.abs(PredictedDC - this.v[1]) > 128) {
                                    PredictedDC = (short)this.v[1];
                                }
                            }
                            short[] sArray = pbi.QFragData[i];
                            sArray[0] = (short)(sArray[0] + PredictedDC);
                        }
                        this.Last[WhichFrame] = pbi.QFragData[i][0];
                        if (isBaseFrame) {
                            this.ExpandKFBlock(pbi, i);
                        } else {
                            this.ExpandBlock(pbi, i);
                        }
                    }
                    ++n;
                    ++i;
                }
            }
        }
        if (pbi.CodedBlockIndex > pbi.UnitFragments >> 1) {
            short[] SwapReconBuffersTemp = pbi.ThisFrameRecon;
            pbi.ThisFrameRecon = pbi.LastFrameRecon;
            pbi.LastFrameRecon = SwapReconBuffersTemp;
            this.CopyNotRecon(pbi, pbi.LastFrameRecon, pbi.ThisFrameRecon);
        } else {
            this.CopyRecon(pbi, pbi.LastFrameRecon, pbi.ThisFrameRecon);
        }
        pbi.filter.LoopFilter(pbi);
        this.UpdateUMVBorder(pbi, pbi.LastFrameRecon);
        if (isBaseFrame) {
            this.CopyRecon(pbi, pbi.GoldenFrame, pbi.LastFrameRecon);
            this.UpdateUMVBorder(pbi, pbi.GoldenFrame);
        }
    }
}

