/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.ElementFactory;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Base64Converter;
import com.fluendo.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;

public class HTTPSrc
extends Element {
    private String userId;
    private String password;
    private String userAgent = "Cortado";
    private String urlString;
    private InputStream input;
    private long contentLength;
    private long offset;
    private long offsetLastMessage = 0L;
    private long skipBytes = 0L;
    private String mime;
    private Caps outCaps;
    private boolean discont;
    private URL documentBase;
    private boolean microSoft = false;
    private static final int DEFAULT_READSIZE = 4096;
    private int readSize = 4096;
    private Pad srcpad = new Pad(1, "src"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doSeek(Event event) {
            boolean result;
            int format = event.parseSeekFormat();
            long position = event.parseSeekPosition();
            if (format == 5 && HTTPSrc.this.contentLength != -1L) {
                position = position * HTTPSrc.this.contentLength / 1000000L;
            } else if (format != 2) {
                Debug.log(2, "can only seek in bytes");
                return false;
            }
            Debug.log(4, this + " flushing");
            this.pushEvent(Event.newFlushStart());
            Object object = this.streamLock;
            synchronized (object) {
                Debug.log(4, this + " synced");
                result = false;
                try {
                    HTTPSrc.this.input = HTTPSrc.this.getInputStream(position);
                    if (HTTPSrc.this.input != null) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.pushEvent(Event.newFlushStop());
                if (result) {
                    this.pushEvent(Event.newNewsegment(false, 2, position, HTTPSrc.this.contentLength, position));
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "restart after seek"));
                    result = this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                } else {
                    HTTPSrc.this.postMessage(Message.newError(this, "error: Seek failed"));
                }
            }
            return result;
        }

        protected boolean eventFunc(Event event) {
            boolean res;
            switch (event.getType()) {
                case 5: {
                    res = this.doSeek(event);
                    break;
                }
                default: {
                    res = super.eventFunc(event);
                }
            }
            return res;
        }

        protected void taskFunc() {
            if (HTTPSrc.this.skipBytes > 0L) {
                Debug.info("Skipping " + HTTPSrc.this.skipBytes + " input bytes");
                try {
                    HTTPSrc.this.offset += HTTPSrc.this.input.skip(HTTPSrc.this.skipBytes);
                }
                catch (IOException e) {
                    Debug.error("input.skip error: " + e);
                    HTTPSrc.this.postMessage(Message.newError(this, "File read error"));
                    return;
                }
                HTTPSrc.this.skipBytes = 0L;
            }
            long left = HTTPSrc.this.contentLength != -1L ? (HTTPSrc.this.microSoft ? (HTTPSrc.this.contentLength == 0L ? 0L : HTTPSrc.this.contentLength - 1L - HTTPSrc.this.offset) : HTTPSrc.this.contentLength - HTTPSrc.this.offset) : -1L;
            int toRead = left != -1L && left < (long)HTTPSrc.this.readSize ? (int)left : HTTPSrc.this.readSize;
            Buffer data = Buffer.create();
            data.ensureSize(toRead);
            data.offset = 0;
            try {
                data.length = toRead > 0 ? HTTPSrc.this.input.read(data.data, 0, toRead) : -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                data.length = 0;
            }
            if (data.length <= 0) {
                HTTPSrc.this.postMessage(Message.newBytePosition(this, HTTPSrc.this.offset));
                HTTPSrc.this.offsetLastMessage = HTTPSrc.this.offset;
                try {
                    HTTPSrc.this.input.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                data.free();
                Debug.log(3, this + " reached EOS");
                this.pushEvent(Event.newEOS());
                HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -3, "reached EOS"));
                this.pauseTask();
                return;
            }
            HTTPSrc.this.offset += data.length;
            if (HTTPSrc.this.offsetLastMessage > HTTPSrc.this.offset) {
                HTTPSrc.this.offsetLastMessage = 0L;
            }
            if (HTTPSrc.this.offset - HTTPSrc.this.offsetLastMessage > HTTPSrc.this.contentLength / 100L) {
                HTTPSrc.this.postMessage(Message.newBytePosition(this, HTTPSrc.this.offset));
                HTTPSrc.this.offsetLastMessage = HTTPSrc.this.offset;
            }
            if (HTTPSrc.this.srcpad.getCaps() == null) {
                String typeMime = ElementFactory.typeFindMime(data.data, data.offset, data.length);
                if (typeMime != null) {
                    if (!typeMime.equals(HTTPSrc.this.mime)) {
                        Debug.log(2, "server contentType: " + HTTPSrc.this.mime + " disagrees with our typeFind: " + typeMime);
                    }
                    Debug.log(3, "using typefind contentType: " + typeMime);
                    HTTPSrc.this.mime = typeMime;
                } else {
                    Debug.log(3, "typefind failed, using server contentType: " + HTTPSrc.this.mime);
                }
                HTTPSrc.this.outCaps = new Caps(HTTPSrc.this.mime);
                HTTPSrc.this.srcpad.setCaps(HTTPSrc.this.outCaps);
            }
            data.caps = HTTPSrc.this.outCaps;
            data.setFlag(1, HTTPSrc.this.discont);
            HTTPSrc.this.discont = false;
            int ret = this.push(data);
            if (ret != 0) {
                if (Pad.isFlowFatal(ret) || ret == -1) {
                    HTTPSrc.this.postMessage(Message.newError(this, "error: " + Pad.getFlowName(ret)));
                    this.pushEvent(Event.newEOS());
                }
                HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, ret, "reason: " + Pad.getFlowName(ret)));
                this.pauseTask();
            }
        }

        protected boolean activateFunc(int mode) {
            boolean res = true;
            switch (mode) {
                case 0: {
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -2, "stopping"));
                    res = this.stopTask();
                    HTTPSrc.this.input = null;
                    HTTPSrc.this.outCaps = null;
                    HTTPSrc.this.mime = null;
                    break;
                }
                case 1: {
                    try {
                        HTTPSrc.this.contentLength = -1L;
                        HTTPSrc.this.input = HTTPSrc.this.getInputStream(0L);
                        if (HTTPSrc.this.input == null) {
                            res = false;
                        }
                    }
                    catch (Exception e) {
                        res = false;
                    }
                    if (!res) break;
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "activating"));
                    res = this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                    break;
                }
                default: {
                    res = false;
                }
            }
            return res;
        }
    };

    private InputStream openWithConnection(URL url, long offset) throws IOException {
        long responseOffset;
        InputStream dis = null;
        URLConnection uc = url.openConnection();
        uc.setRequestProperty("Connection", "Keep-Alive");
        String range = offset != 0L && this.contentLength != -1L ? "bytes=" + offset + "-" + (this.contentLength - 1L) : (offset != 0L ? "bytes=" + offset + "-" : null);
        if (range != null) {
            Debug.info("doing range: " + range);
            uc.setRequestProperty("Range", range);
        }
        uc.setRequestProperty("User-Agent", this.userAgent);
        if (this.userId != null && this.password != null) {
            String userPassword = this.userId + ":" + this.password;
            String encoding = Base64Converter.encode(userPassword.getBytes());
            uc.setRequestProperty("Authorization", "Basic " + encoding);
        }
        uc.setRequestProperty("Content-Type", "application/octet-stream");
        dis = uc.getInputStream();
        String responseRange = uc.getHeaderField("Content-Range");
        if (responseRange == null) {
            Debug.info("Response contained no Content-Range field, assuming offset=0");
            responseOffset = 0L;
        } else {
            try {
                MessageFormat format = new MessageFormat("bytes {0,number}-{1,number}");
                format.setLocale(Locale.US);
                Object[] parts = format.parse(responseRange);
                responseOffset = ((Number)parts[0]).longValue();
                if (responseOffset < 0L) {
                    responseOffset = 0L;
                }
                Debug.debug("Stream successfully with offset " + responseOffset);
            }
            catch (Exception e) {
                Debug.info("Error parsing Content-Range header");
                responseOffset = 0L;
            }
        }
        this.contentLength = (long)uc.getHeaderFieldInt("Content-Length", -1) + responseOffset;
        this.mime = uc.getContentType();
        this.offset = responseOffset;
        this.skipBytes = responseOffset < offset ? offset - responseOffset : 0L;
        return dis;
    }

    private InputStream getInputStream(long offset) throws Exception {
        InputStream dis = null;
        try {
            URL url;
            this.postMessage(Message.newResource(this, "Opening " + this.urlString));
            Debug.log(3, "reading from url " + this.urlString);
            boolean isAbsolute = this.urlString.startsWith("http://");
            if (!isAbsolute && this.documentBase != null) {
                Debug.log(3, "parsing in document base");
                url = new URL(this.documentBase, this.urlString);
            } else {
                Debug.log(3, "parsing as absolute URL");
                url = new URL(this.urlString);
            }
            Debug.log(3, "trying to open " + url + " at offset " + offset);
            dis = this.openWithConnection(url, offset);
            this.discont = true;
            if (this.contentLength != -1L) {
                this.postMessage(Message.newDuration(this, 2, this.contentLength));
            }
            Debug.log(3, "opened " + url);
            Debug.log(3, "contentLength: " + this.contentLength);
            Debug.log(3, "server contentType: " + this.mime);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            this.postMessage(Message.newError(this, "Not allowed " + this.urlString + "..."));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        return dis;
    }

    public String getFactoryName() {
        return "httpsrc";
    }

    public HTTPSrc() {
        if (System.getProperty("java.vendor").toUpperCase().startsWith("MICROSOFT", 0)) {
            Debug.log(2, "Found MS JVM, work around inputStream EOS bugs.");
            this.microSoft = true;
        }
        this.addPad(this.srcpad);
    }

    public synchronized boolean setProperty(String name, Object value) {
        boolean res = true;
        if (name.equals("url")) {
            this.urlString = String.valueOf(value);
        } else if (name.equals("documentBase")) {
            this.documentBase = (URL)value;
        } else if (name.equals("userId")) {
            this.userId = value == null ? null : String.valueOf(value);
        } else if (name.equals("userAgent")) {
            this.userAgent = String.valueOf(value);
        } else if (name.equals("password")) {
            this.password = value == null ? null : String.valueOf(value);
        } else if (name.equals("readSize")) {
            this.readSize = Integer.parseInt((String)value);
        } else {
            res = false;
        }
        return res;
    }
}

