/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jkate.Comment;
import com.fluendo.jkate.Info;
import com.fluendo.jkate.State;
import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.plugin.OggPayload;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import java.util.Vector;

public class KateDec
extends Element
implements OggPayload {
    private static final byte[] signature = new byte[]{-128, 107, 97, 116, 101, 0, 0, 0};
    private Info ki;
    private Comment kc;
    private State k;
    private Packet op;
    private int packetno;
    private long basetime = 0L;
    private long lastTs;
    private boolean haveBOS = false;
    private boolean haveDecoder = false;
    private Pad srcPad = new Pad(1, "src"){

        protected boolean eventFunc(Event event) {
            return KateDec.this.sinkPad.pushEvent(event);
        }
    };
    private Pad sinkPad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            boolean result;
            switch (event.getType()) {
                case 1: {
                    result = KateDec.this.srcPad.pushEvent(event);
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, "synced " + this);
                        break;
                    }
                }
                case 2: {
                    result = KateDec.this.srcPad.pushEvent(event);
                    break;
                }
                case 3: {
                    Debug.log(3, "got EOS " + this);
                    result = KateDec.this.srcPad.pushEvent(event);
                    break;
                }
                case 4: {
                    KateDec.this.basetime = event.parseNewsegmentStart();
                    Debug.info("new segment: base time " + KateDec.this.basetime);
                    result = KateDec.this.srcPad.pushEvent(event);
                    break;
                }
                default: {
                    result = KateDec.this.srcPad.pushEvent(event);
                }
            }
            return result;
        }

        protected int chainFunc(Buffer buf) {
            int result;
            Debug.log(4, this.parent.getName() + " <<< " + buf);
            ((KateDec)KateDec.this).op.packet_base = buf.data;
            ((KateDec)KateDec.this).op.packet = buf.offset;
            ((KateDec)KateDec.this).op.bytes = buf.length;
            ((KateDec)KateDec.this).op.b_o_s = KateDec.this.packetno == 0 ? 1 : 0;
            ((KateDec)KateDec.this).op.e_o_s = 0;
            ((KateDec)KateDec.this).op.packetno = KateDec.this.packetno;
            long timestamp = buf.timestamp;
            Debug.log(4, "Kate chainFunc with packetno " + KateDec.this.packetno + ", haveDecoder " + KateDec.this.haveDecoder);
            if (!KateDec.this.haveDecoder) {
                int result2 = KateDec.this.takeHeader(KateDec.this.op);
                if (result2 < 0) {
                    buf.free();
                    Debug.log(1, "does not contain Kate data.");
                    return -5;
                }
                if (result2 > 0) {
                    Debug.log(4, "Kate initialized for decoding");
                    this.caps = new Caps("application/x-kate-event");
                }
                buf.free();
                KateDec.this.packetno++;
                return 0;
            }
            if ((((KateDec)KateDec.this).op.packet_base[((KateDec)KateDec.this).op.packet] & 0x80) == 128) {
                Debug.log(4, "ignoring header");
                buf.free();
                return 0;
            }
            if (timestamp != -1L) {
                KateDec.this.lastTs = timestamp;
            }
            try {
                result = KateDec.this.k.decodePacketin(KateDec.this.op);
                if (result < 0) {
                    buf.free();
                    Debug.log(1, "Error Decoding Kate.");
                    KateDec.this.postMessage(Message.newError(this, "Error decoding Kate"));
                    return -5;
                }
                com.fluendo.jkate.Event ev = KateDec.this.k.decodeEventOut();
                if (ev != null) {
                    buf.object = ev;
                    buf.caps = this.caps;
                    buf.timestamp = KateDec.this.granuleToDuration(ev.start);
                    buf.timestampEnd = buf.timestamp + KateDec.this.granuleToDuration(ev.duration);
                    Debug.log(4, this.parent.getName() + " >>> " + buf);
                    Debug.debug("Got Kate text: " + new String(ev.text) + " from " + buf.timestamp + " to " + buf.timestampEnd + ", basetime " + KateDec.this.basetime);
                    result = KateDec.this.srcPad.push(buf);
                    Debug.log(4, "push returned " + result);
                } else {
                    Debug.debug("Got no event");
                    buf.free();
                    result = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                KateDec.this.postMessage(Message.newError(this, e.getMessage()));
                result = -5;
            }
            KateDec.this.packetno++;
            return result;
        }

        protected boolean activateFunc(int mode) {
            return true;
        }
    };

    public boolean isType(Packet op) {
        return this.typeFind(op.packet_base, op.packet, op.bytes) > 0;
    }

    public boolean isKeyFrame(Packet op) {
        return true;
    }

    public boolean isDiscontinuous() {
        return true;
    }

    public int takeHeader(Packet op) {
        int ret = this.ki.decodeHeader(this.kc, op);
        if (ret >= 0) {
            this.haveBOS = true;
        }
        if (ret > 0) {
            this.k.decodeInit(this.ki);
            Debug.debug("Kate decoder ready");
            this.haveDecoder = true;
        }
        return ret;
    }

    public boolean isHeader(Packet op) {
        return (op.packet_base[op.packet] & 0x80) == 128;
    }

    public long getFirstTs(Vector packets) {
        int i;
        int len = packets.size();
        Buffer data = null;
        for (i = 0; i < len; ++i) {
            data = (Buffer)packets.elementAt(i);
            if (data.time_offset != -1L) break;
        }
        if (i == packets.size()) {
            return -1L;
        }
        long time = this.granuleToTime(data.time_offset);
        data = (Buffer)packets.elementAt(0);
        data.timestamp = time - (long)(i + 1) * (1000000L * (long)this.ki.gps_denominator / (long)this.ki.gps_numerator);
        return time;
    }

    public long granuleToTime(long gp) {
        if (gp < 0L || !this.haveDecoder) {
            return -1L;
        }
        long res = (long)(this.k.granuleTime(gp) * 1000000.0);
        return res;
    }

    public long granuleToDuration(long gp) {
        if (gp < 0L || !this.haveDecoder) {
            return -1L;
        }
        long res = (long)(this.k.granuleDuration(gp) * 1000000.0);
        return res;
    }

    public KateDec() {
        this.ki = new Info();
        this.kc = new Comment();
        this.k = new State();
        this.op = new Packet();
        this.addPad(this.srcPad);
        this.addPad(this.sinkPad);
    }

    protected int changeState(int transition) {
        switch (transition) {
            case 18: {
                this.lastTs = -1L;
                this.packetno = 0;
                break;
            }
        }
        int res = super.changeState(transition);
        switch (transition) {
            case 33: {
                this.ki.clear();
                this.kc.clear();
                this.k.clear();
                break;
            }
        }
        return res;
    }

    public Object getProperty(String name) {
        if (name.equals("language")) {
            return this.ki.language;
        }
        if (name.equals("category")) {
            return this.ki.category;
        }
        return super.getProperty(name);
    }

    public String getFactoryName() {
        return "katedec";
    }

    public String getMime() {
        return "application/x-kate";
    }

    public String getMime(Packet op) {
        Info ki = new Info();
        Comment kc = new Comment();
        if (!this.isType(op)) {
            return null;
        }
        int ret = ki.decodeHeader(kc, op);
        if (ret < 0) {
            return null;
        }
        String mime = "application/x-kate";
        if (!ki.language.equals("")) {
            mime = mime + ";language=" + ki.language;
        }
        if (!ki.category.equals("")) {
            mime = mime + ";category=" + ki.category;
        }
        return mime;
    }

    public int typeFind(byte[] data, int offset, int length) {
        if (MemUtils.startsWith(data, offset, length, signature)) {
            return 10;
        }
        return -1;
    }
}

