/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.xpp3;

import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.SubstitutionGroup;
import de.lessvoid.xml.xpp3.XmlProcessor;
import java.io.InputStream;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser {
    private static Logger log = Logger.getLogger(XmlParser.class.getName());
    private XmlPullParser xpp;

    public XmlParser(XmlPullParser xppParam) {
        this.xpp = xppParam;
    }

    public void read(InputStream inputStream) throws Exception {
        this.xpp.setInput(inputStream, null);
    }

    public void required(String tag, XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            throw new Exception("found end tag but required tag [" + tag + "]");
        }
        if (!this.matchesTag(tag)) {
            throw new Exception("Expected tag [" + tag + "] but was [" + this.xpp.getName() + "]");
        }
        this.processElement(xmlElement);
        this.nextTag();
    }

    public void optional(String tag, XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            return;
        }
        if (!this.matchesTag(tag)) {
            return;
        }
        this.processElement(xmlElement);
        this.nextTag();
    }

    public void zeroOrMore(String tag, XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            return;
        }
        if (!this.matchesTag(tag)) {
            return;
        }
        this.processElement(xmlElement);
        this.nextTag();
        this.zeroOrMore(tag, xmlElement);
    }

    private boolean isEndTag() throws Exception {
        return 3 == this.xpp.getEventType();
    }

    public void zeroOrMore(SubstitutionGroup substGroup) throws Exception {
        if (this.isEndTag()) {
            return;
        }
        XmlProcessor element = substGroup.matches(this.xpp.getName());
        if (element == null) {
            return;
        }
        this.processElement(element);
        this.nextTag();
        this.zeroOrMore(substGroup);
    }

    public void oneOrMore(String tag, XmlProcessor xmlElement) throws Exception {
        if (this.isEndTag()) {
            throw new Exception("End tag reached but was expecting [" + tag + "]");
        }
        if (!this.matchesTag(tag)) {
            throw new Exception("Expected tag [" + tag + "] but was [" + this.xpp.getName() + "]");
        }
        this.processElement(xmlElement);
        this.nextTag();
        this.zeroOrMore(tag, xmlElement);
    }

    private void processElement(XmlProcessor xmlElement) throws Exception {
        log.fine("process element: " + xmlElement.getClass().getName());
        try {
            xmlElement.process(this, new Attributes(this.xpp));
        }
        catch (Exception ex) {
            if (!(ex instanceof XmlPullParserException)) {
                throw new XmlPullParserException("Error parsing document.", this.xpp, (Throwable)ex);
            }
            throw ex;
        }
    }

    private boolean matchesTag(String tag) {
        return tag.equals(this.xpp.getName());
    }

    public void nextTag() throws Exception {
        if (this.xpp.getEventType() == 1) {
            return;
        }
        int eventType = this.xpp.next();
        while (eventType != 1) {
            if (eventType == 3) {
                this.indent();
                log.fine(this.indent() + "END <" + this.xpp.getName() + ">");
                return;
            }
            if (eventType == 2) {
                log.fine(this.indent() + "START <" + this.xpp.getName() + ">");
                return;
            }
            eventType = this.xpp.next();
        }
    }

    private String indent() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.xpp.getDepth(); ++i) {
            b.append(" ");
        }
        return b.toString();
    }
}

