/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd.vmd;

import com.jme3.animation.Bone;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.ik.IKControl;
import projectkyoto.jme3.mmd.nativebullet.PhysicsControl;
import projectkyoto.jme3.mmd.vmd.BoneMotionList;
import projectkyoto.jme3.mmd.vmd.IPUtil;
import projectkyoto.jme3.mmd.vmd.SkinList;
import projectkyoto.jme3.mmd.vmd.VMDMotionComparator;
import projectkyoto.jme3.mmd.vmd.VMDSkinComparator;
import projectkyoto.mmd.file.PMDBone;
import projectkyoto.mmd.file.PMDIKData;
import projectkyoto.mmd.file.PMDRigidBody;
import projectkyoto.mmd.file.VMDFile;
import projectkyoto.mmd.file.VMDMotion;
import projectkyoto.mmd.file.VMDSkin;

public class VMDControl
extends AbstractControl {
    final PMDNode pmdNode;
    final VMDFile vmdFile;
    int currentFrameNo = 0;
    final Map<String, BoneMotionList> motionMap = new HashMap<String, BoneMotionList>();
    BoneMotionList[] boneMotionListArray;
    final Map<String, SkinList> skinMap = new HashMap<String, SkinList>();
    SkinList[] skinListArray;
    int lastFrameNo = 0;
    boolean pause = false;
    static final VMDMotionComparator vmc = new VMDMotionComparator();
    static final VMDSkinComparator vmsc = new VMDSkinComparator();
    final PhysicsControl physicsControl;
    int[] boneEnabled;
    final IKControl ikControl;
    TickListener tl = new TickListener();
    float currentTime = 0.0f;
    Quat4f tmpq1 = new Quat4f();
    Quat4f tmpq2 = new Quat4f();
    Point3f tmpp1 = new Point3f();
    Point3f tmpp2 = new Point3f();
    float prevTpf = 0.0f;
    float accuracy = 0.008333334f;

    public VMDControl(PMDNode pmdNode, VMDFile vmdFile) {
        this.pmdNode = pmdNode;
        this.vmdFile = vmdFile;
        this.initMotionMap();
        this.physicsControl = new PhysicsControl(pmdNode);
        this.ikControl = new IKControl(pmdNode);
        this.boneEnabled = new int[pmdNode.getSkeleton().getBoneCount()];
        for (int i = 0; i < this.boneEnabled.length; ++i) {
            this.boneEnabled[i] = 1;
        }
        block1: for (PMDIKData ikData : pmdNode.getPmdModel().getIkList().getPmdIKData()) {
            int targetBoneIndex = ikData.getIkTargetBoneIndex();
            for (PMDRigidBody rb : pmdNode.getPmdModel().getRigidBodyList().getRigidBodyArray()) {
                if (rb.getRelBoneIndex() != targetBoneIndex || rb.getRigidBodyType() == 0) continue;
                this.boneEnabled[targetBoneIndex] = 0;
                continue block1;
            }
        }
        this.ikControl.setBoneEnabled(this.boneEnabled);
        for (int i = pmdNode.getSkeleton().getBoneCount() - 1; i >= 0; --i) {
            if (this.boneEnabled[i] != 1) continue;
            Bone bone = pmdNode.getSkeleton().getBone(i);
            bone.setUserControl(true);
        }
    }

    private void initMotionMap() {
        for (VMDMotion m : this.vmdFile.getMotionArray()) {
            BoneMotionList motionList = this.motionMap.get(m.getBoneName());
            if (motionList == null) {
                motionList = new BoneMotionList();
                motionList.boneName = m.getBoneName();
                motionList.bone = this.pmdNode.getSkeleton().getBone(m.getBoneName());
                motionList.boneIndex = this.pmdNode.getSkeleton().getBoneIndex(motionList.bone);
                this.motionMap.put(m.getBoneName(), motionList);
            }
            motionList.add(m);
            if (m.getFrameNo() <= this.lastFrameNo) continue;
            this.lastFrameNo = m.getFrameNo();
        }
        Iterator<BoneMotionList> it = this.motionMap.values().iterator();
        while (it.hasNext()) {
            BoneMotionList ml = it.next();
            for (PMDBone pmdBone : this.pmdNode.getPmdModel().getBoneList().getBones()) {
                if (!pmdBone.getBoneName().equals(ml.boneName)) continue;
                ml.boneType = pmdBone.getBoneType();
            }
        }
        while (it.hasNext()) {
            BoneMotionList ml = it.next();
            for (PMDBone pmdBone : this.pmdNode.getPmdModel().getBoneList().getBones()) {
                if (!pmdBone.getBoneName().equals(ml.boneName)) continue;
            }
        }
        for (BoneMotionList ml : this.motionMap.values()) {
            Collections.sort(ml, vmc);
            ml.setCurrentCount(0);
        }
        for (VMDSkin skin : this.vmdFile.getSkinArray()) {
            SkinList skinList = this.skinMap.get(skin.getSkinName());
            if (skinList == null) {
                skinList = new SkinList();
                skinList.skinName = skin.getSkinName();
                skinList.skin = this.pmdNode.getSkinMap().get(skin.getSkinName());
                this.skinMap.put(skinList.skinName, skinList);
            }
            skinList.add(skin);
            if (skin.getFlameNo() <= this.lastFrameNo) continue;
            this.lastFrameNo = skin.getFlameNo();
        }
        for (SkinList skinList : this.skinMap.values()) {
            Collections.sort(skinList, vmsc);
        }
        this.boneMotionListArray = this.motionMap.values().toArray(new BoneMotionList[this.motionMap.size()]);
        this.skinListArray = this.skinMap.values().toArray(new SkinList[this.skinMap.size()]);
    }

    protected void controlUpdate(float tpf) {
        boolean needUpdateSkin = false;
        if (tpf != 0.0f && !this.pause) {
            tpf += this.prevTpf;
            while (tpf > this.accuracy) {
                this.controlUpdate2(this.accuracy);
                this.physicsControl.update(this.accuracy);
                this.physicsControl.getWorld().getPhysicsSpace().distributeEvents();
                needUpdateSkin = true;
                tpf -= this.accuracy;
            }
            this.physicsControl.getWorld().applyResultToBone();
            this.prevTpf = tpf;
            if (needUpdateSkin) {
                this.resetSkins();
                this.calcSkins();
            }
        }
    }

    protected void controlUpdate2(float tpf) {
        if (!this.pause) {
            this.currentTime += tpf;
            this.currentFrameNo = (int)(this.currentTime * 30.0f);
            this.calcBonePosition();
            this.physicsControl.getWorld().updateKinematicPos();
        }
    }

    void calcBonePosition() {
        for (int i = this.pmdNode.getSkeleton().getBoneCount() - 1; i >= 0; --i) {
            if (this.boneEnabled[i] != 1) continue;
            Bone bone = this.pmdNode.getSkeleton().getBone(i);
            bone.getLocalRotation().loadIdentity();
        }
        for (BoneMotionList bml : this.boneMotionListArray) {
            VMDMotion m2;
            VMDMotion m1;
            Bone bone;
            if (bml.size() == 0 || (bone = bml.bone) == null || this.boneEnabled[bml.boneIndex] != 1) continue;
            if (bml.size() - 1 < bml.currentCount) {
                m1 = (VMDMotion)bml.get(bml.size() - 1);
                Quat4f q = m1.getRotation();
                bone.getLocalRotation().set(q.x, q.y, q.z, q.w);
                Point3f p = m1.getLocation();
                Vector3f v = bone.getWorldBindPosition();
                bone.getLocalPosition().set(v.x + p.x, v.y + p.y, v.z + p.z);
                continue;
            }
            int count = bml.currentCount;
            while (true) {
                VMDMotion m;
                if ((m = bml.m2).getFrameNo() > this.currentFrameNo) {
                    m1 = bml.m1;
                    m2 = bml.m2;
                    break;
                }
                if (count >= bml.size()) {
                    m1 = bml.m1;
                    m2 = bml.m2;
                    break;
                }
                bml.setCurrentCount(++count);
            }
            if (m1.getFrameNo() > this.currentFrameNo) {
                this.tmpq1.set((Tuple4f)m1.getRotation());
                this.tmpp1.set((Tuple3f)m1.getLocation());
                continue;
            }
            if (m2.getFrameNo() == m1.getFrameNo()) {
                this.tmpq1.set((Tuple4f)m1.getRotation());
                this.tmpp1.set((Tuple3f)m1.getLocation());
            } else {
                float f = (float)(m2.getFrameNo() - m1.getFrameNo()) * 1.0f / 30.0f;
                assert (f >= 0.0f);
                float f2 = this.currentTime - (float)m1.getFrameNo() / 30.0f;
                assert (f2 >= 0.0f);
                float f3 = f2 / f;
                float fx = IPUtil.calcIp(bml, f3, 0);
                float fy = IPUtil.calcIp(bml, f3, 1);
                float fz = IPUtil.calcIp(bml, f3, 2);
                float fr = IPUtil.calcIp(bml, f3, 3);
                this.tmpq1.interpolate(m1.getRotation(), m2.getRotation(), fr);
                this.tmpp1.x = m1.getLocation().x + (m2.getLocation().x - m1.getLocation().x) * fx;
                this.tmpp1.y = m1.getLocation().y + (m2.getLocation().y - m1.getLocation().y) * fy;
                this.tmpp1.z = m1.getLocation().z + (m2.getLocation().z - m1.getLocation().z) * fz;
            }
            bone.getLocalRotation().set(this.tmpq1.x, this.tmpq1.y, this.tmpq1.z, this.tmpq1.w);
            bone.getLocalRotation().normalizeLocal();
            Point3f p = this.tmpp1;
            Vector3f v = bone.getWorldBindPosition();
            bone.getLocalPosition().set(v.x + p.x, v.y + p.y, v.z + p.z);
        }
        this.pmdNode.getSkeleton().updateWorldVectors();
        this.ikControl.updateIKBoneRotation();
        for (int i = 0; i < this.pmdNode.getPmdModel().getBoneList().getBoneCount(); ++i) {
            PMDBone pmdBone = this.pmdNode.getPmdModel().getBoneList().getBones()[i];
            if (pmdBone.getBoneType() != 5 || this.boneEnabled[i] != 1) continue;
            Bone bone = this.pmdNode.getSkeleton().getBone(i);
            Bone targetBone = this.pmdNode.getSkeleton().getBone(pmdBone.getTargetBone());
            bone.getLocalRotation().multLocal(targetBone.getLocalRotation());
            bone.updateWorldVectors();
        }
    }

    public void calcSkins() {
        for (SkinList skinList : this.skinListArray) {
            float weight;
            float w1 = 0.0f;
            float w2 = 0.0f;
            int c1 = 0;
            int c2 = 0;
            int skinListSize = skinList.size();
            while (skinList.currentCount < skinListSize) {
                VMDSkin skin = (VMDSkin)skinList.get(skinList.currentCount);
                if (skin.getFlameNo() > this.currentFrameNo) {
                    w2 = skin.getWeight();
                    c2 = skin.getFlameNo();
                    if (skinList.currentCount > 0) {
                        skin = (VMDSkin)skinList.get(skinList.currentCount - 1);
                        w1 = skin.getWeight();
                        c1 = skin.getFlameNo();
                        break;
                    }
                    w1 = 0.0f;
                    c1 = 0;
                    break;
                }
                ++skinList.currentCount;
            }
            if (skinList.currentCount == skinListSize) {
                weight = ((VMDSkin)skinList.get(skinList.currentCount - 1)).getWeight();
            } else {
                float f1 = (float)(c2 - c1) * 1.0f / 30.0f;
                float f2 = this.currentTime - (float)c1 / 30.0f;
                weight = f1 > 0.0f ? w1 + (w2 - w1) * f2 / f1 : w2;
            }
            if (skinList.skin == null) continue;
            skinList.skin.setWeight(weight);
        }
    }

    public void resetSkins() {
        for (String skinName : this.pmdNode.getSkinSet()) {
            this.pmdNode.setSkinWeight(skinName, 0.0f);
        }
    }

    public void setFrameNo(int frameNo) {
        for (BoneMotionList boneMotionList : this.boneMotionListArray) {
            int count = boneMotionList.size() - 1;
            for (int i = 0; i < boneMotionList.size(); ++i) {
                VMDMotion m = (VMDMotion)boneMotionList.get(i);
                if (m.getFrameNo() <= frameNo) continue;
                count = i;
                break;
            }
            boneMotionList.setCurrentCount(count);
        }
        this.currentFrameNo = frameNo;
        this.currentTime = (float)frameNo / 30.0f;
        this.calcBonePosition();
        block2: for (ArrayList arrayList : this.skinListArray) {
            ((SkinList)arrayList).currentCount = arrayList.size() - 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                VMDSkin skin = (VMDSkin)arrayList.get(i);
                if (skin.getFlameNo() <= frameNo) continue;
                ((SkinList)arrayList).currentCount = i;
                continue block2;
            }
        }
        this.calcSkins();
        this.physicsControl.getWorld().resetRigidBodyPos();
    }

    public int getFrameNo() {
        return this.currentFrameNo;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public int getLastFrameNo() {
        return this.lastFrameNo;
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PhysicsControl getPhysicsControl() {
        return this.physicsControl;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
        this.physicsControl.getWorld().setAccuracy(accuracy);
    }

    class TickListener
    implements PhysicsTickListener {
        TickListener() {
        }

        public void prePhysicsTick(PhysicsSpace ps, float f) {
            VMDControl.this.controlUpdate2(f);
        }

        public void physicsTick(PhysicsSpace ps, float f) {
            VMDControl.this.physicsControl.getWorld().applyResultToBone();
        }
    }
}

