/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;

public class PMDIKData {
    private int ikBoneIndex;
    private int ikTargetBoneIndex;
    private int ikChainLength;
    private int iterations;
    private float controlWeight;
    private int[] ikChildBoneIndex;

    public PMDIKData(DataInputStreamLittleEndian is) throws IOException {
        this.ikBoneIndex = is.readUnsignedShort();
        this.ikTargetBoneIndex = is.readUnsignedShort();
        this.ikChainLength = is.readByte() & 0xFF;
        this.iterations = is.readShort();
        this.controlWeight = is.readFloat();
        this.ikChildBoneIndex = new int[this.ikChainLength];
        for (int i = 0; i < this.ikChainLength; ++i) {
            this.ikChildBoneIndex[i] = is.readUnsignedShort();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ikBoneIndex = " + this.ikBoneIndex);
        sb.append("\n").append("ikTargetBoneIndex = " + this.ikTargetBoneIndex);
        sb.append(" ikChainLength = " + this.ikChainLength);
        sb.append(" \niterations = " + this.iterations);
        sb.append("\ncontrolWeight = " + this.controlWeight);
        sb.append("\n{");
        for (int i = 0; i < this.ikChainLength; ++i) {
            sb.append("ikChildBoneIndex = " + this.ikChildBoneIndex[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public float getControlWeight() {
        return this.controlWeight;
    }

    public void setControlWeight(float controlWeight) {
        this.controlWeight = controlWeight;
    }

    public int getIkBoneIndex() {
        return this.ikBoneIndex;
    }

    public void setIkBoneIndex(int ikBoneIndex) {
        this.ikBoneIndex = ikBoneIndex;
    }

    public int getIkChainLength() {
        return this.ikChainLength;
    }

    public void setIkChainLength(int ikChainLength) {
        this.ikChainLength = ikChainLength;
    }

    public int[] getIkChildBoneIndex() {
        return this.ikChildBoneIndex;
    }

    public void setIkChildBoneIndex(int[] ikChildBoneIndex) {
        this.ikChildBoneIndex = ikChildBoneIndex;
    }

    public int getIkTargetBoneIndex() {
        return this.ikTargetBoneIndex;
    }

    public void setIkTargetBoneIndex(int ikTargetBoneIndex) {
        this.ikTargetBoneIndex = ikTargetBoneIndex;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }
}

