/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDSkinData;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.MeshData;
import projectkyoto.mmd.file.util2.SkinMeshData;
import projectkyoto.mmd.file.util2.VertIndex;

public class MeshConverter {
    PMDModel model;
    int maxBoneSize = 20;
    List<MeshData> meshDataList = new ArrayList<MeshData>();
    SkinMeshData skinMeshData;
    HashMap<PMDVertex, Integer> meshTmpVertMap = new HashMap();
    HashMap<Integer, Integer> skinTmpVertMap = new HashMap();
    VertIndex tmpvi = new VertIndex(0);
    Set<VertIndex> skinVertSet = new HashSet<VertIndex>();

    public MeshConverter(PMDModel model) {
        this.model = model;
        this.skinMeshData = new SkinMeshData(this, model);
        this.initSkinVertSet();
    }

    private final void initSkinVertSet() {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData skinData = this.model.getSkinData()[skinCount];
            if (skinData.getSkinType() != 0) continue;
            for (int skinVertCount = 0; skinVertCount < skinData.getSkinVertCount(); ++skinVertCount) {
                VertIndex vi = new VertIndex(skinData.getSkinVertData()[skinVertCount].getSkinVertIndex());
                this.skinVertSet.add(vi);
            }
        }
    }

    public void checkDupMaterial() {
        for (int i1 = 0; i1 < this.model.getMaterialCount(); ++i1) {
            for (int i2 = i1 + 1; i2 < this.model.getMaterialCount() && !this.model.getMaterial()[i1].equals(this.model.getMaterial()[i2]); ++i2) {
            }
        }
    }

    void printFaceVertSize() {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData pMDSkinData = this.model.getSkinData()[skinCount];
        }
    }

    public void convertMesh() {
        int faceVertNo = 0;
        for (int materialNo = 0; materialNo < this.model.getMaterialCount(); ++materialNo) {
            PMDMaterial material = this.model.getMaterial()[materialNo];
            MeshData meshData = new MeshData(this.model, this.maxBoneSize, material);
            for (int meshIndex = this.meshDataList.size() - 1; meshIndex >= 0; --meshIndex) {
                PMDMaterial material2 = this.meshDataList.get(meshIndex).getMaterial();
                if (!material.equals(material2)) continue;
                meshData = this.meshDataList.get(meshIndex);
                for (int i = meshData.getVertexList().size() - 1; i >= 0; --i) {
                    PMDVertex v = meshData.getVertexList().get(i);
                    this.meshTmpVertMap.put(v, i);
                }
                break;
            }
            if (material.getFaceVertCount() == 0) continue;
            if (!this.meshDataList.contains(meshData)) {
                this.meshDataList.add(meshData);
            }
            for (int materialFaceVertNo = 0; materialFaceVertNo < material.getFaceVertCount(); materialFaceVertNo += 3) {
                int i3;
                int i1 = this.model.getFaceVertIndex()[faceVertNo++];
                int i2 = this.model.getFaceVertIndex()[faceVertNo++];
                if (this.containsSkin(i1, i2, i3 = this.model.getFaceVertIndex()[faceVertNo++])) {
                    this.addSkinTriangle(material, i1, i2, i3);
                    continue;
                }
                if (meshData.addTriangle(this, i1, i2, i3)) continue;
                meshData = new MeshData(this.model, this.maxBoneSize, material);
                this.meshTmpVertMap.clear();
                this.meshDataList.add(meshData);
                meshData.addTriangle(this, i1, i2, i3);
            }
            if (meshData.getVertexList().size() != 0) continue;
            this.meshDataList.remove(this.meshDataList.size() - 1);
        }
        int vertSizeSum = 0;
        int boneSizeSum = 0;
        int indexSizeSum = 0;
        for (MeshData meshData : this.meshDataList) {
            vertSizeSum += meshData.getVertexList().size();
            boneSizeSum += meshData.getBoneList().size();
            indexSizeSum += meshData.getIndexList().size();
        }
        for (MeshData meshData : this.meshDataList) {
        }
        System.out.println("meshDataCount = " + this.meshDataList.size());
    }

    void printMeshData(MeshData meshData) {
        System.out.println("vertSize = " + meshData.getVertexList().size() + " indexSize = " + meshData.getIndexList().size() + " boneSize = " + meshData.getBoneList().size());
    }

    boolean containsSkin(int i1, int i2, int i3) {
        return this.containsSkin(i1) || this.containsSkin(i2) || this.containsSkin(i3);
    }

    boolean containsSkin(int i) {
        this.tmpvi.index = i;
        return this.skinVertSet.contains(this.tmpvi);
    }

    boolean _containsSkin(int i) {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData skinData = this.model.getSkinData()[skinCount];
            if (skinData.getSkinType() != 0) continue;
            for (int skinVertCount = 0; skinVertCount < skinData.getSkinVertCount(); ++skinVertCount) {
                if (i != skinData.getSkinVertData()[skinVertCount].getSkinVertIndex()) continue;
                return true;
            }
        }
        return false;
    }

    void addSkinTriangle(PMDMaterial material, int i1, int i2, int i3) {
        this.skinMeshData.addTriangle(this, material, i1, i2, i3);
    }

    public int getMaxBoneSize() {
        return this.maxBoneSize;
    }

    public void setMaxBoneSize(int maxBoneSize) {
        this.maxBoneSize = maxBoneSize;
    }

    public List<MeshData> getMeshDataList() {
        return this.meshDataList;
    }

    public void setMeshDataList(List<MeshData> meshDataList) {
        this.meshDataList = meshDataList;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    public SkinMeshData getSkinMeshData() {
        return this.skinMeshData;
    }

    public void setSkinMeshData(SkinMeshData skinMeshData) {
        this.skinMeshData = skinMeshData;
    }
}

