/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.sound.openal.slick;

import de.lessvoid.nifty.sound.openal.slick.AudioImpl;
import de.lessvoid.nifty.sound.openal.slick.SoundStore;
import ibxm.Module;
import ibxm.OpenALMODPlayer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class MODSound
extends AudioImpl {
    private static OpenALMODPlayer player = new OpenALMODPlayer();
    private Module module;
    private SoundStore store;

    public MODSound(SoundStore store, InputStream in) throws IOException {
        this.store = store;
        this.module = OpenALMODPlayer.loadModule((InputStream)in);
    }

    public int playAsMusic(float pitch, float gain, boolean loop) {
        this.cleanUpSource();
        player.play(this.module, this.store.getSource(0), loop, SoundStore.get().isMusicOn());
        player.setup(pitch, 1.0f);
        this.store.setCurrentMusicVolume(gain);
        this.store.setMOD(this);
        return this.store.getSource(0);
    }

    private void cleanUpSource() {
        AL10.alSourceStop((int)this.store.getSource(0));
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        int queued = AL10.alGetSourcei((int)this.store.getSource(0), (int)4117);
        while (queued > 0) {
            AL10.alSourceUnqueueBuffers((int)this.store.getSource(0), (IntBuffer)buffer);
            --queued;
        }
        AL10.alSourcei((int)this.store.getSource(0), (int)4105, (int)0);
    }

    public void poll() {
        player.update();
    }

    public int playAsSoundEffect(float pitch, float gain, boolean loop) {
        return -1;
    }

    public void stop() {
        this.store.setMOD(null);
    }

    public float getPosition() {
        throw new RuntimeException("Positioning on modules is not currently supported");
    }

    public boolean setPosition(float position) {
        throw new RuntimeException("Positioning on modules is not currently supported");
    }
}

