/**
 * Nyarudinoのスケッチシステムを使用するプロジェクトのテンプレートです。
 */
//#define SKETCH_STACK_SIZE 80 //スケッチのスタックサイズを変えるときは、ここで設定。
#include "boot/sketch.h"
#include "NyLPC_stdlib.h"
#include "LPC17xx.h"

void setup(void)
{
	//Setup and initialization before run scheduler
	//通常は、各種サービスの起動設定をします。
}
#ifndef __CC_ARM

#if defined(__ICCARM__)
inline int __semihost(int reason, const void *arg) {
    return __semihosting(reason, (void*)arg);
}
#else

#ifdef __thumb__
#   define AngelSWI            0xAB
#   define AngelSWIInsn        "bkpt"
#   define AngelSWIAsm          bkpt
#else
#   define AngelSWI            0x123456
#   define AngelSWIInsn        "swi"
#   define AngelSWIAsm          swi
#endif

static inline int __semihost(int reason, const void *arg) {
    int value;

    asm volatile (
       "mov r0, %1"          "\n\t"
       "mov r1, %2"          "\n\t"
       AngelSWIInsn " %a3"   "\n\t"
       "mov %0, r0"
       : "=r" (value)                                         /* output operands             */
       : "r" (reason), "r" (arg), "i" (AngelSWI)              /* input operands              */
       : "r0", "r1", "r2", "r3", "ip", "lr", "memory", "cc"   /* list of clobbered registers */
    );

    return value;
}
#endif
#endif
int semihost_exit(void) {
    uint32_t args[4];
    return __semihost(0x18, args);
}
void loop(void)
{
	semihost_exit();
	int i;
	LPC_PINCON->PINSEL0=0;
	LPC_PINCON->PINSEL1=0;
	LPC_PINCON->PINSEL2=0;
	LPC_PINCON->PINSEL3=0;
	LPC_PINCON->PINMODE0=0xffffffff;
	LPC_PINCON->PINMODE1=0xffffffff;
	LPC_PINCON->PINMODE2=0xffffffff;
	LPC_PINCON->PINMODE3=0xffffffff;
	LPC_PINCON->PINMODE_OD0=0x0;
	LPC_PINCON->PINMODE_OD1=0x0;
	LPC_GPIO0->FIODIR=0xffffffff;
	LPC_GPIO0->FIOMASK=0;
	LPC_GPIO1->FIODIR=0xffffffff;
	LPC_GPIO1->FIOMASK=0;

	//Implementation
	//ここにメインタスクを書きます。
	for(;;){
		LPC_GPIO0->FIOPIN=0xffffffff;
		LPC_GPIO1->FIOPIN=0xffffffff;
//		NyLPC_cThread_sleep(100);
//		LPC_GPIO0->FIOPIN=0x00;
//		LPC_GPIO1->FIOPIN=0x00;
//		NyLPC_cThread_sleep(100);

//		LPC_PINCON_TypeDef *PINSEL0=0;
	}
}
