/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#include "NyLPC_protected_sdfsService.h"
#include "task.h"
/**********************************************************************
 *
 * NyLPC_TcSdFile class
 *
 **********************************************************************/


NyLPC_TBool NyLPC_cSdFile_initialize(const NyLPC_TChar* i_fname,BYTE i_ff_mode,NyLPC_TcSdFile_t* o_inst)
{
	NyLPC_TBool ret=NyLPC_TBool_FALSE;

	NyLPC_ArgAssert(i_fname!=NULL);
	NyLPC_ArgAssert(o_inst!=NULL);
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());
	//排他
	if(xSemaphoreTakeRecursive( _NyLPC_TcSdFsService_inst->mutex,NyLPC_TcSdService_WAIT_ACCESS))
	{
		//マウント保証
		if(NyLPC_cSdService_prepareSD()){
			//ファイルオープン
			_NyLPC_TcSdFsService_inst->_last_err=f_open(&(o_inst->_fsfp),i_fname,i_ff_mode);
			if(_NyLPC_TcSdFsService_inst->_last_err==FR_OK){
				//ファイル開いた
				ret=NyLPC_TBool_TRUE;
			}
		}
		xSemaphoreGiveRecursive(_NyLPC_TcSdFsService_inst->mutex);
	}
	return ret;
}


void NyLPC_cSdFile_finalize(NyLPC_TcSdFile_t* i_inst)
{
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());

	//クローズしてなかったら閉じる
	if(i_inst->_fsfp.fs!=NULL){
		NyLPC_cSdFile_close(i_inst);
	}
	//FIL取ってたら開放する。
	if(_NyLPC_TcSdFsService_inst->_locked_object==i_inst){
		NyLPC_cSdFile_releaseFIL(i_inst);
	}
}

NyLPC_TBool NyLPC_cSdFile_read(NyLPC_TcSdFile_t* i_inst,void* o_buf,NyLPC_TInt32 i_buf_len,NyLPC_TInt32* o_dest_len)
{
	NyLPC_ArgAssert(o_buf!=NULL);
	NyLPC_ArgAssert(i_buf_len>0);
	NyLPC_ArgAssert(o_dest_len!=NULL);
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());

	if(!xSemaphoreTakeRecursive(_NyLPC_TcSdFsService_inst->mutex,(portTickType)10))
	{
		NyLPC_OnErrorGoto(ERROR_FAILED);
	}
	//読出し
	_NyLPC_TcSdFsService_inst->_last_err=f_read(&i_inst->_fsfp,o_buf,i_buf_len,(UINT*)o_dest_len);

	//ロック解除
	xSemaphoreGiveRecursive(_NyLPC_TcSdFsService_inst->mutex);
	if(_NyLPC_TcSdFsService_inst->_last_err!=FR_OK){
		NyLPC_OnErrorGoto(ERROR_FAILED);
	}
	return NyLPC_TBool_TRUE;
ERROR_FAILED:
	return NyLPC_TBool_FALSE;
}
NyLPC_TBool NyLPC_cSdFile_write(NyLPC_TcSdFile_t* i_inst,void* i_buf,NyLPC_TInt32 i_buf_len)
{
	NyLPC_ArgAssert(i_inst!=NULL);
	NyLPC_ArgAssert(i_buf!=NULL);
	NyLPC_ArgAssert(i_buf_len>0);
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());

	UINT wl;
	if(!xSemaphoreTakeRecursive(_NyLPC_TcSdFsService_inst->mutex,NyLPC_TcSdService_WAIT_ACCESS))
	{
		NyLPC_OnErrorGoto(ERROR_FAILED);
	}
	//書込み
	do{
		_NyLPC_TcSdFsService_inst->_last_err=f_write(&i_inst->_fsfp,i_buf,i_buf_len,&wl);
		i_buf_len-=wl;
	}while(i_buf_len>0 && _NyLPC_TcSdFsService_inst->_last_err==FR_OK);


	//ロック解除
	xSemaphoreGiveRecursive(_NyLPC_TcSdFsService_inst->mutex);
	if(_NyLPC_TcSdFsService_inst->_last_err!=FR_OK){
		NyLPC_OnErrorGoto(ERROR_FAILED);
	}
	return NyLPC_TBool_TRUE;
ERROR_FAILED:
	return NyLPC_TBool_FALSE;
}


NyLPC_TBool NyLPC_cSdFile_close(NyLPC_TcSdFile_t* i_inst)
{
	NyLPC_ArgAssert(i_inst!=NULL);
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());
	//二重ロックOK
	if(!xSemaphoreTakeRecursive(_NyLPC_TcSdFsService_inst->mutex,NyLPC_TcSdService_WAIT_ACCESS))
	{
		NyLPC_OnErrorGoto(ERROR_FAILED);
	}
	//クローズ
	_NyLPC_TcSdFsService_inst->_last_err=f_close(&i_inst->_fsfp);
	//解除
	xSemaphoreGiveRecursive(_NyLPC_TcSdFsService_inst->mutex);
	if(_NyLPC_TcSdFsService_inst->_last_err!=FR_OK){
		NyLPC_OnErrorGoto(ERROR_FAILED);
	}
	return NyLPC_TBool_TRUE;
ERROR_FAILED:
	return NyLPC_TBool_FALSE;
}

NyLPC_TBool NyLPC_cSdFile_getFIL(NyLPC_TcSdFile_t* i_inst,FIL** o_fil)
{
	NyLPC_ArgAssert(i_inst!=NULL);
	NyLPC_ArgAssert(o_fil!=NULL);
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());

	//自分がロック中なら何もしない
	if(_NyLPC_TcSdFsService_inst->_locked_object==i_inst){
	}else{
	//自分がロックしていなければロック待ち
		if(!xSemaphoreTakeRecursive(_NyLPC_TcSdFsService_inst->mutex,NyLPC_TcSdService_WAIT_ACCESS))
		{
			NyLPC_OnErrorGoto(ERROR_FAILED);
		}
		//ロックオブジェクトを記録
		_NyLPC_TcSdFsService_inst->_locked_object=i_inst;
	}
	*o_fil=&(i_inst->_fsfp);
	return NyLPC_TBool_TRUE;
ERROR_FAILED:
	return NyLPC_TBool_FALSE;
}
void NyLPC_cSdFile_releaseFIL(NyLPC_TcSdFile_t* i_inst)
{
	NyLPC_ArgAssert(i_inst!=NULL);
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());
	NyLPC_Assert(_NyLPC_TcSdFsService_inst->_locked_object==i_inst);

	//自分自身がロックしていたら解除
	if(_NyLPC_TcSdFsService_inst->_locked_object==i_inst){
		//ロック解除
		_NyLPC_TcSdFsService_inst->_locked_object=NULL;
		xSemaphoreGiveRecursive(_NyLPC_TcSdFsService_inst->mutex);
	}
	return;
}
