/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *
 * Parts of this file were leveraged from uIP:
 *
 * Copyright (c) 2001-2003, Adam Dunkels.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef NYLPC_CIPV4TCP_H_
#define NYLPC_CIPV4TCP_H_


typedef struct NyLPC_TcIPv4 NyLPC_TcIPv4_t;

#include "NyLPC_uip.h"
#include "NyLPC_cTcpListener.h"
#include "NyLPC_cTcpSocket.h"






/**********************************************************************
 *
 * class NyLPC_TcIPv4
 *
 **********************************************************************/

/**
 * TCPListenerの最大生成数
 */
#define NyLPC_cIPv4_MAX_TCP_LISTENER 10

/**
 * TCPSocketの最大生成数
 */
#define NyLPC_cIPv4_MAX_TCP_SOCKET 10




struct NyLPC_TcIPv4
{
	const NyLPC_TcIPv4Config_t* _ref_config;
	NyLPC_TcPtrTbl_t _listener_tbl;
	NyLPC_TcPtrTbl_t _socket_tbl;
	NyLPC_TcTcpListener_t* _listener_array_buf[NyLPC_cIPv4_MAX_TCP_LISTENER];
	/**
	 * ソケット管理リスト。追加はuipタスク。削除はApplicationタスクが実行。
	 */
	NyLPC_TcTcpSocket_t* _socket_array_buf[NyLPC_cIPv4_MAX_TCP_SOCKET];

};

void NyLPC_cIPv4_initialize(
	NyLPC_TcIPv4_t* i_inst);

void NyLPC_cIPv4_finalize(
	NyLPC_TcIPv4_t* i_inst);

void NyLPC_cIPv4_start(
	NyLPC_TcIPv4_t* i_inst,
	const NyLPC_TcIPv4Config_t* i_ref_configlation);

void NyLPC_cIPv4_stop(
	NyLPC_TcIPv4_t* i_inst);

/**
 * この関数は、ソケットオブジェクトを管理リストへ追加します。
 */
NyLPC_TBool NyLPC_cIPv4_addSocket(
	NyLPC_TcIPv4_t* i_inst,
	NyLPC_TcTcpSocket_t* i_sock);

/**
 * この関数は、ソケットオブジェクトを管理リストから削除します。
 */
NyLPC_TBool NyLPC_cIPv4_removeSocket(
	NyLPC_TcIPv4_t* i_inst,
	NyLPC_TcTcpSocket_t* i_sock);

/**
 * この関数は、リスナオブジェクトを管理リストへ追加します。
 */
NyLPC_TBool NyLPC_cIPv4_addListener(
	NyLPC_TcIPv4_t* i_inst,
	NyLPC_TcTcpListener_t* i_listener);

/**
 * この関数は、リスナオブジェクトを管理リストから削除します。
 */
NyLPC_TBool NyLPC_cIPv4_removeListener(
	NyLPC_TcIPv4_t* i_inst,
	NyLPC_TcTcpListener_t* i_listener);

/**
 * TCPペイロードを処理して、管理しているインスタンスを更新します。
 * また、即時応答パケットを返します。
 */
NyLPC_TBool NyLPC_cIPv4_rx(NyLPC_TcIPv4_t* i_inst,void* i_rx,NyLPC_TUInt16 i_rx_size);
void NyLPC_cIPv4_periodec(NyLPC_TcIPv4_t* i_inst);



#endif
