/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#ifndef NYLPC_CIPV4CONFIG_H_
#define NYLPC_CIPV4CONFIG_H_


typedef struct NyLPC_TcIPv4Config NyLPC_TcIPv4Config_t;

#include "NyLPC_uip.h"


/**********************************************************************
 *
 * class NyLPC_TcIPv4Config
 *
 **********************************************************************/





struct NyLPC_TcIPv4Config
{
	/** ethernetAddress*/
	struct NyLPC_TEthAddr eth_mac;
	/** IPアドレス*/
	struct NyLPC_TIPv4Addr ip_addr;
	/** ネットマスク*/
	struct NyLPC_TIPv4Addr netmask;
	/** デフォルトゲートウェイ*/
	struct NyLPC_TIPv4Addr dr_addr;
	/** デフォルトMMS 送信パケットのデフォルトMMS、受信パケットのデフォルトMMSとして使います。*/
	NyLPC_TUInt16 default_mss;
};

/**
 * イーサネット用にコンフィギュレーションを初期化します。
 * @param i_ether_frame_len
 * イーサネットフレームのサイズ。この数値から、MSSのデフォルト値を計算します。
 */
void NyLPC_cIPv4Config_initialzeForEthernet(NyLPC_TcIPv4Config_t* i_inst,const struct NyLPC_TEthAddr* i_ether_addr,NyLPC_TUInt16 i_ether_frame_len);
void NyLPC_cIPv4Config_setDefaultRoute(NyLPC_TcIPv4Config_t* i_inst,const struct NyLPC_TIPv4Addr* i_dr_addr);
void NyLPC_cIPv4Config_setIp(NyLPC_TcIPv4Config_t* i_inst,const struct NyLPC_TIPv4Addr* i_ipaddr,const struct NyLPC_TIPv4Addr* i_netmask);

/**
 * このIPアドレスが、ローカルIPアドレスであるかを確認します。
 */
NyLPC_TBool NyLPC_cIPv4Config_isLocalIP(const NyLPC_TcIPv4Config_t* i_inst,const struct NyLPC_TIPv4Addr* i_target_ip);

#endif
