#include "NyLPC_cNet.h"

const char* NyLPC_cNet_PlatformName;

static const char* PNAME_LPCXPRESSO1769="LPCXpresso1769";
static const char* PNAME_MBED="mbed";

void NyLPC_cNet_initialize(NyLPC_TcNet_t* i_inst)
{
	//uipサービス初期化。いろいろ利用可能に。
	NyLPC_cUipService_initialize();
}

void NyLPC_cNet_start(NyLPC_TcNet_t* i_inst,const NyLPC_TcNetConfig_t* i_ref_config)
{
	NyLPC_cUipService_start(&(i_ref_config->interface_setting.ethernet));
	//プラットフォーム名を推測(デバイス名の初めの1文字だけ見る。)
	switch(*(NyLPC_cUipService_refDeviceName())){
	case 'L':
		NyLPC_cNet_PlatformName=PNAME_LPCXPRESSO1769;
		break;
	case 'D':
		NyLPC_cNet_PlatformName=PNAME_MBED;
		break;
	default:
		break;
	}
	return;
}
