#ifndef NYLPC_CNETCONFIG_H_
#define NYLPC_CNETCONFIG_H_

#include "NyLPC_stdlib.h"
#include "NyLPC_uipService.h"

#define NyLPC_cNetConfig_INTERFACE_TYPE_ETHERNET 1

/**
 * クラス型を定義します。
 * NyLPC_cNetConfigクラスは、NyLPC_NetConfigの初期化データを保持します。
 * 初期化データのロード・セーブ機能を提供します。
 */
typedef struct NyLPC_TcNetConfig NyLPC_TcNetConfig_t;


/**
 * NyLPC_TcFifoBufferクラスの構造体です。
 */
struct NyLPC_TcNetConfig
{
	/** Must be 1*/
	NyLPC_TUInt16 version;
	/** 配列の最大サイズ*/
	NyLPC_TUInt16 interface_type;
	/** インタフェイス層の設定*/
	union{
		/** Ethernet mac address */
		NyLPC_TcIPv4Config_t ethernet;
//
//		struct{
//			struct NyLPC_TEthAddr mac_addr;
//		}ethernet2;
	}interface_setting;
//	/** ip addressの設定*/
//	struct{
//		struct NyLPC_TIPv4Addr ip;
//		struct NyLPC_TIPv4Addr mask;
//		struct NyLPC_TIPv4Addr gateway;
//	}ipv4;
};

/**
 * インスタンスを初期化します。
 * 値は工場出荷時設定になります。
 */
void NyLPC_cNetConfig_initialize(NyLPC_TcNetConfig_t* i_inst);
/**
 * インスタンスを終期化します。
 */
#define NyLPC_cNetConfig_finalize(i_inst);

#endif /* NYLPC_CNETCONFIG_H_ */
