
#ifndef NYLPC_CHTTPD_H_
#define NYLPC_CHTTPD_H_

#include "NyLPC_stdlib.h"
#include "../NyLPC_cNetConfig.h"
#include "NyLPC_cHttpd.h"
#include "NyLPC_cHttpdThread.h"
#ifndef DEFINE_NyLPC_TcHttpdConnection_t
	typedef struct NyLPC_TcHttpdConnection NyLPC_TcHttpdConnection_t;
	#define DEFINE_NyLPC_TcHttpdConnection_t
#endif



#define NyLPC_cNet_NUMBER_OF_THREAD 2
typedef void (*NyLPC_TcHttpd_onRequest)(NyLPC_TcHttpdConnection_t* i_inst);

/**
 * class definition
 */
#ifndef DEFINE_NyLPC_TcHttpd_t
	typedef struct NyLPC_TcHttpd NyLPC_TcHttpd_t;
	#define DEFINE_NyLPC_TcHttpd_t
#endif
struct NyLPC_TcHttpd
{
	struct{
		NyLPC_TcHttpd_onRequest onRequest;
	}function;
	NyLPC_TcMutex_t _mutex;
	NyLPC_TcTcpListener_t _listener;
	NyLPC_TcHttpdThread_t _thread[NyLPC_cNet_NUMBER_OF_THREAD];
	NyLPC_TUInt16 _num_of_active_connection;
};




void NyLPC_cHttpd_initialize(NyLPC_TcHttpd_t* i_inst,NyLPC_TUInt16 i_port_number);
void NyLPC_cHttpd_finalize(NyLPC_TcHttpd_t* i_inst);
void NyLPC_cHttpd_loop(NyLPC_TcHttpd_t* i_inst);




#endif /* NYLPC_CHTTPD_H_ */
