<?php
require_once("MiMicCore.php");
require_once("MiMicRemoteMcuInterface.php");
require_once('MiMic_LPC1769_Mcu.php');
require_once('MiMic_LPC1769_Pin.php');
require_once('MiMic_LPC1769_Port.php');
require_once('MiMic_LPC1769_Peripheral.php');
require_once('MiMic_LPC1769_Adc.php');
require_once('MiMic_LPC1769_Gpio.php');
require_once('MiMic_LPC1769_Pwm.php');
require_once('MiMic_LPC1769_Memory.php');
require_once('MiMic_LPC1769_Ni.php');
class MiMic_LPC1769
{
	/**
	 * @param &array[uint] i_db
	 */
	public static function BCF_setBit($i_addr,$i_mask,$i_val,$i_shl,&$i_db)
	{
		array_push($i_db,$i_addr);
		array_push($i_db,~($i_mask<<$i_shl));
		array_push($i_db,($i_mask & $i_val) << $i_shl);
		return 'EA00EA01EA02DB0700AA0701AE0702DF0700';
	}
	public static function BCF_setMem($i_addr,$i_val,&$i_db)
	{
		array_push($i_db,$i_addr);
		array_push($i_db,$i_val);
		return 'EA00EA01DF0100';
	}
	public static function BCF_getMem($i_addr,&$i_db)
	{
		array_push($i_db,$i_addr);
		return 'EA00DB0000EE00';
	}
	const _BCF_READMEM='EA00DB0000EE00';
	const _BCF_END='ZZ.E';

	public static $FUNC_NAME=array('GPIO','AD','DA','PWM');
	public static $PHL_NAME=array('GPIO','ADC','DAC','PWM');

	/**
	 * LPCXpressoのPeripheralパラメタを格納したテーブルである。要素はペリフェラル識別子である。
	 * UM10360のChapter 4: LPC17xx Clocking and power controlを元に定義している。
	 * ペリフェラル識別子はペリフェラルのレジスタ番号とビット番号を格納した配列である。
	 * <pre>
	 * PHL:{PHL_NAME:[PCLKSELreg#,PCLKSELbit#,PCONPbit#]}
	 * </pre>
	 * nullはそのビットが無効であることを示す。
	 * @name LPCXpresso1769#PHL
	 * @constant
	 * @field
	 * @example
	 * LPCXpresso1796.PHLADC //ADC peripheral
	 */
	public static $PHL=array(
			'WDT'=>array(0,0,null),
			'TIMER0'=>array(0,2,1),
			'TIMER1'=>array(0,4,2),
			'UART0'=>array(0,6,3),
			'UART1'=>array(0,8,4),
			'PWM1'=>array(0,12,6),
			'I2C0'=>array(0,14,7),
			'SPI'=>array(0,16,8),
			'RTC'=>array(null,null,9),
			'SSPI1'=>array(0,20,10),
			'DAC'=>array(0,22,null),
			'ADC'=>array(0,24,12),
			'CAN1'=>array(0,26,13),
			'CAN2'=>array(0,28,14),
			'ACF'=>array(0,30,null),
			'QEI'=>array(1,0,18),
			'GPIOINT'=>array(1,2,15),
			'PCB'=>array(1,4,null),
			'I2C1'=>array(1,6,19),
			'SSP0'=>array(1,10,21),
			'TIMER2'=>array(1,12,22),
			'TIMER3'=>array(1,14,23),
			'UART2'=>array(1,16,24),
			'UART3'=>array(1,18,25),
			'I2C2'=>array(1,20,26),
			'I2S'=>array(1,22,27),
			'RIT'=>array(1,26,16),
			'SYSCON'=>array(1,28,null),
			'PWM_MC'=>array(1,30,17),//MC?
			'GPDMA'=>array(null,null,29),
			'ENET'=>array(null,null,30),
			'USB'=>array(null,null,31)
	);
	public static $P0=array(
	array(0,0,0,0,'GPIO0.0','RD1','TXD3','SDA1'),
	array(0,0,0,1,'GPIO0.1','TD1','RXD3','SCL1'),//1
	array(0,0,0,2,'GPIO0.2','TXD0','AD0.7',null),//2
	array(0,0,0,3,'GPIO0.3','RXD0','AD0.6',null),//3
	array(0,0,0,4,'GPIO0.4','I2SRX_CLK','RD2','CAP2.0'),//4
	array(0,0,0,5,'GPIO0.5','I2SRX_WS','TD2','CAP2.1'),//5
	array(0,0,0,6,'GPIO0.6','I2SRX_SDA','SSEL1','MAT2.0'),//6
	array(0,0,0,7,'GPIO0.7','I2STX_CLK','SCK1',	'MAT2.1'),//7
	array(0,0,0,8,'GPIO0.8','I2STX_WS','MISO1','MAT2.2'),//8
	array(0,0,0,9,'GPIO0.9','I2STX_SDA','MOSI1','MAT2.3'),//9
	array(0,0,0,10,'GPIO0.10','TXD2','SDA2','MAT3.0'),//10
	array(0,0,0,11,'GPIO0.11','RXD2','SCL2','MAT3.1'),//11
	null,null,null,//12,13,14
	array(0,0,0,15,'GPIO0.15','TXD1','SCK0','SCK'),//15
	array(1,1,0,16,'GPIO0.16','RXD1','SSEL0','SSEL'),//16
	array(1,1,0,17,'GPIO0.17','CTS1','MISO0','MISO'),//17
	array(1,1,0,18,'GPIO0.18','DCD1','MOSI0','MOSI'),//18
	array(1,1,0,19,'GPIO0.19','DSR1',null,'SDA1'),//19
	array(1,1,0,20,'GPIO0.20','DTR1',null,'SCL1'),//20
	array(1,1,0,21,'GPIO0.21','RI1',null,'RD1'),//21
	array(1,1,0,22,'GPIO0.22','RTS1',null,'TD1'),//22
	array(1,1,0,23,'GPIO0.23','AD0.0','I2SRX_CLK','CAP3.0'),//23
	array(1,1,0,24,'GPIO0.24','AD0.1','I2SRX_WS','CAP3.1'),//24
	array(1,1,0,25,'GPIO0.25','AD0.2','I2SRX_SDA','TXD3'),//25
	array(1,1,0,26,'GPIO0.26','AD0.3','AOUT','RXD3'),//26
	array(1,null,null,22,'GPIO0.27','SDA0',	'USB_SDA',null),//27
	array(1,null,null,24,'GPIO0.28','SCL0',	'USB_SCL',null),//28
	array(1,null,0,29,'GPIO0.29','USB_D+',null,null),//29
	array(1,null,0,30,'GPIO0.30','USB_D-',null,null)//30
	);

	public static $P1=array(
	array(2,2,1,0,'GPIO1.0','ENET_TXD0',null,null),//0
	array(2,2,1,1,'GPIO1.1','ENET_TXD1',null,null),//1
	null,null,//2,3
	array(2,2,1,4,'GPIO1.4','ENET_TX_EN',null,null),//4
	null,null,null,//5,6,7
	array(2,2,1,8,'GPIO1.8','ENET_CRS',null,null),//8
	array(2,2,1,9,'GPIO1.9','ENET_RXD0',null,null),//9
	array(2,2,1,10,'GPIO1.10','ENET_RXD1',null,null),//10
	null,null,null,//11,12,13
	array(2,2,1,14,'GPIO1.14','ENET_RX_ER',null,null),//14
	array(2,2,1,15,'GPIO1.15','ENET_REF_CLK',null,null),//15
	array(3,3,1,16,'GPIO1.16','ENET_MDC',null,null),//16
	array(3,3,1,17,'GPIO1.17','ENET_MDIO',null,null),//17
	array(3,3,1,18,'GPIO1.18','USB_UP_LED','PWM1.1','CAP1.0'),//18
	array(3,3,1,19,'GPIO1.19','MCOA0','USB_PPWR','CAP1.1'),//19
	array(3,3,1,20,'GPIO1.20','MCI0','PWM1.2','SCK0'),//20
	array(3,3,1,21,'GPIO1.21','MCABORT','PWM1.3','SSEL0'),//21
	array(3,3,1,22,'GPIO1.22','MCOB0','USB_PWRD','MAT1.0'),//22
	array(3,3,1,23,'GPIO1.23','MCI1','PWM1.4','MISO0'),//23
	array(3,3,1,24,'GPIO1.24','MCI2','PWM1.5','MOSI0'),//24
	array(3,3,1,25,'GPIO1.25','MCOA1',null,'MAT1.1'),//25
	array(3,3,1,26,'GPIO1.26','MCOB1','PWM1.6','CAP0.0'),//26
	array(3,3,1,27,'GPIO1.27','CLKOUT','USB_OVRCR','CAP0.1'),//27
	array(3,3,1,28,'GPIO1.28','MCOA2','PCAP1.0','MAT0.0'),//28
	array(3,3,1,29,'GPIO1.29','MCOB2','PCAP1.1','MAT0.1'),//29
	array(3,3,1,30,'GPIO1.30',null,'VBUS','AD0.4'),//30
	array(3,3,1,31,'GPIO1.31',null,'SCK1','AD0.5')//31
	);

	public static $P2=array(
	array(4,4,2,0,'GPIO2.0','PWM1.1','TXD1',null),//0
	array(4,4,2,1,'GPIO2.1','PWM1.2','RXD1',null),//1
	array(4,4,2,2,'GPIO2.2','PWM1.3','CTS1',null),//2
	array(4,4,2,3,'GPIO2.3','PWM1.4','DCD1',null),//3
	array(4,4,2,4,'GPIO2.4','PWM1.5','DSR1',null),//4
	array(4,4,2,5,'GPIO2.5','PWM1.6','DTR1',null),//5
	array(4,4,2,6,'GPIO2.6','PCAP1.0','RI1',null),//6
	array(4,4,2,7,'GPIO2.7','RD2','RTS1',null),//7
	array(4,4,2,8,'GPIO2.8','TD2','TXD2','ENET_MDC'),//8
	array(4,4,2,9,'GPIO2.9','USB_CONNECT','RXD2','ENET_MDIO'),//9
	array(4,4,2,10,'GPIO2.10','EINT0','NMI',null),//10
	array(4,4,2,11,'GPIO2.11','EINT1',null,'I2STX_CLK'),//11
	array(4,4,2,12,'GPIO2.12','EINT2',null,'I2STX_WS'),//12
	array(4,4,2,13,'GPIO2.13','EINT3',null,'I2STX_SDA')//13
	);

	public static $P3=array(
	null/* 0*/,null/* 1*/,null/* 2*/,null/* 3*/,null/* 4*/,null/* 5*/,null/* 6*/,null/* 7*/,null/* 8*/,null/* 9*/,
	null/*10*/,null/*11*/,null/*12*/,null/*13*/,null/*14*/,null/*15*/,null/*16*/,null/*17*/,null/*18*/,null/*19*/,
	null/*20*/,null/*21*/,null/*22*/,null/*23*/,null/*24*/,
	array(7,7,3,25,'GPIO3.25',null,'MAT0.0','PWM1.2'),//25
	array(7,7,3,26,'GPIO3.26','STCLK','MAT0.1','PWM1.3')//26
	);

	public static $P4=array(
	null/* 0*/,null/* 1*/,null/* 2*/,null/* 3*/,null/* 4*/,null/* 5*/,null/* 6*/,null/* 7*/,null/* 8*/,null/* 9*/,
	null/*10*/,null/*11*/,null/*12*/,null/*13*/,null/*14*/,null/*15*/,null/*16*/,null/*17*/,null/*18*/,null/*19*/,
	null/*20*/,null/*21*/,null/*22*/,null/*23*/,null/*24*/,null/*25*/,null/*26*/,null/*27*/,
	array(9,9,4,28,'GPIO4.28','RX_MCLK','MAT2.0','TXD3'),//28
	array(9,9,4,29,'GPIO4.29','TX_MCLK','MAT2.1','RXD3')//29
	);

	/**
	 * [forSystem]ピン識別子のアクセス関数である。
	 * ピン機能シンボルのプレフィクス（機能シンボル）を、 ピン識別子を元に、完全な名称に変換する。
	 * ピンにFunctionが含まれているか調べることが出来る。
	 * @private
	 * @return string
	 */

	public static function completePinFunctionName($i_pin,$i_prefix)
	{
		//配列探索
		for($i=4;$i<8;$i++){
			if(strpos($i_pin[$i],$i_prefix)===0){
				//ピン情報の構成
				return $i_pin[$i];
			}
		}
		throw new MiMicException("The function name '".$i_prefix."' is not unknown.");
	}



	const UINT32_INVALID=0xffffffff;

	/**
	 * [forSystem]ピン識別子のアクセス関数。
	 * ピン識別値から、Pinレジスタの番号と、ビット位置を取り出す。
	 * @private
	 * @return hash array
	 * {s:pinselのレジスタ番号、m:modeのレジスタ番号、,o:odのレジスタ番号,sbm:mode,selのビット位置,ob:odのビット位置}
	 */
	public static function getPinRegInfo($i_pin)
	{
		$r=array(
				's'=>$i_pin[0],
				'm'=>$i_pin[1],
				'o'=>$i_pin[2]);
//print_r($r);
		if($i_pin[3]!=null){
			$r['smb']=($i_pin[3]%16)*2;
			$r['ob']=$i_pin[3];
		}else{
			$r['smb']=null;
			$r['ob']=null;
		}
		return $r;
	}

	/**
	 * [forSystem]ピン識別子のアクセス関数。
	 * PIN機能名に一致するPinsel値を取り出す。
	 * @private
	 */
	public static function getPinSelByFunctionName($i_pin,$i_name)
	{
		for($i=4;$i<8;$i++){
			if($i_pin[$i]==$i_name){
				//ピン情報の構成
				return $i-4;
			}
		}
		throw new MiMicException("The function name '".$i_name."' has not function.");
	}

	/**
	 * [forSystem]ピンが、ピン機能シンボルを持つか返す。
	 * @private
	 */
	public static function hasPinFunctionName($i_pin,$i_name)
	{
		for($i=4;$i<8;$i++){
			if(strpos($i_pin->sel[$i],$i_name)===0){
				return true;
			}
		}
		return false;
	}
}

?>

