#ifndef NYLPC_CNET_H_
#define NYLPC_CNET_H_

#include "NyLPC_stdlib.h"
#include "NyLPC_uipService.h"
#include "NyLPC_cNetConfig.h"

/**
 * クラス型を定義します。
 */
typedef struct NyLPC_TcNet NyLPC_TcNet_t;

/**
 * Platformを示す文字列
 */
extern const char* NyLPC_cNet_PlatformName;


struct NyLPC_TcNet
{
	int dummy;
};

/**
 * ネットワークを初期化する。
 */
void NyLPC_cNet_initialize(NyLPC_TcNet_t* i_inst);

#define NyLPC_cNet_finalize(inst)
/**
 * 関数は、ネットワークアダプタの値を元にNyLPC_cMiMicEnv_PlatformName変数の値を更新します。
 * @param i_ref_config
 * Networkコンフィギュレーション変数。このオブジェクトはcNetをstopするまで維持すること。
 */
void NyLPC_cNet_start(NyLPC_TcNet_t* i_inst,const NyLPC_TcNetConfig_t* i_ref_config);


#endif /* NYLPC_CNET_H_ */
