/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#include "NyLPC_cModUrl.h"
#include "NyLPC_stdlib.h"
#include "NyLPC_http.h"
#include "NyLPC_cHttpModUtils_protected.h"
#include "../NyLPC_cHttpdConnection_protected.h"

typedef struct TcHeaderParser
{
	NyLPC_TcHttpBasicHeaderParser_t super;
	char* url_buf;
	NyLPC_TInt16 length_of_buf;
	NyLPC_TInt16 length_of_url;
}TcHeaderParser_t;

static NyLPC_TBool NyLPC_cModUrl_messageHandler(NyLPC_TcHttpBasicHeaderParser_t* i_inst,const NyLPC_TChar* i_name,NyLPC_TChar i_c,struct NyLPC_THttpBasicHeader* o_out)
{
	(void)i_inst;
	(void)i_name;
	(void)i_c;
	return NyLPC_TBool_TRUE;
}
static NyLPC_TBool NyLPC_cModUrl_urlHandler(NyLPC_TcHttpBasicHeaderParser_t* i_inst,NyLPC_TChar i_c,struct NyLPC_THttpBasicHeader* o_out)
{
	TcHeaderParser_t* inst=(TcHeaderParser_t*)i_inst;
	//読み飛ばし
	if(inst->length_of_url<0){
		inst->length_of_url++;
		return NyLPC_TBool_TRUE;
	}
	inst->url_buf[inst->length_of_url]=i_c;
	inst->length_of_url++;
	if(i_c=='\0'){
		return NyLPC_TBool_TRUE;//Terminate
	}
	if(inst->length_of_url==inst->length_of_buf){
		return NyLPC_TBool_FALSE;//長すぎる。
	}
	return NyLPC_TBool_TRUE;
}
/**
 * デフォルトハンドラ
 */
static const struct NyLPC_TcHttpBasicHeaderParser_Handler _handler=
{
	NyLPC_cModUrl_messageHandler,
	NyLPC_cModUrl_urlHandler
};



void NyLPC_cModUrl_initialize(NyLPC_TcModUrl_t* i_inst)
{

}
void NyLPC_cModUrl_finalize(NyLPC_TcModUrl_t* i_inst)
{

}

const struct NyLPC_THttpBasicHeader* NyLPC_cModUrl_getHeader(const NyLPC_TcModUrl_t* i_inst)
{
	return &(i_inst->_header);
}

/**
 * Methodタイプを返します。
 */
NyLPC_THttpMethodType NyLPC_cModUrl_getMethod(const NyLPC_TcModUrl_t* i_inst)
{
	return i_inst->_header.startline.req.method;
}




NyLPC_TBool NyLPC_cModUrl_execute2(NyLPC_TcModUrl_t* i_inst,NyLPC_TcHttpdConnection_t* i_connection,char* o_url_buf,NyLPC_TInt16 i_length_buf,NyLPC_TInt16 i_pass_prefix_len)
{
	TcHeaderParser_t parser;
	NyLPC_Assert(i_length_buf>0);
	NyLPC_Assert(i_pass_prefix_len>=0);
	if(!NyLPC_cHttpdConnection_getReqStatus(i_connection)==NyLPC_cHttpdConnection_ReqStatus_REQPARSE)
	{
		NyLPC_OnErrorGoto(Error1);
	}
	//リクエストParse済へ遷移
	NyLPC_cHttpdConnection_setReqStatusParsed(i_connection);

	NyLPC_cHttpBasicHeaderParser_initialize(&parser.super,&_handler);
	parser.length_of_buf=i_length_buf;
	parser.length_of_url=-i_pass_prefix_len;//無視するPrefix長
	parser.url_buf=o_url_buf;
	parser.url_buf[0]='0';//URL長<=prefix長に備えてNULLターミネイト
	//プリフェッチしたデータを流す
	NyLPC_cHttpBasicHeaderParser_parseInit(&parser.super,&(i_inst->_header));
	NyLPC_cHttpdConnection_pushPrefetchInfo(i_connection,&parser.super,&(i_inst->_header));
	//後続をストリームから取り込む
	if(!NyLPC_cHttpBasicHeaderParser_parseStream(&parser.super,NyLPC_cHttpdConnection_refStream(i_connection),&(i_inst->_header))){
		NyLPC_OnErrorGoto(Error2);
	}
	if(!NyLPC_cHttpBasicHeaderParser_parseFinish(&parser.super,&(i_inst->_header))){
		NyLPC_OnErrorGoto(Error2);
	}
	//Connection Modeの設定 1.1 && !closeの場合はCONTINUE
	if(i_inst->_header.connection!=NyLPC_THttpMessgeHeader_Connection_CLOSE && i_inst->_header.startline.req.version==NyLPC_THttpVersion_11)
	{
		NyLPC_cHttpdConnection_setConnectionMode(i_connection,NyLPC_TcHttpdConnection_CONNECTION_MODE_CONTINUE);
	}
	NyLPC_cHttpBasicHeaderParser_finalize(&parser);
	return NyLPC_TBool_TRUE;
Error2:
	//400Error
	NyLPC_cHttpdConnection_sendResponseHeader2(i_connection,400,"text/html",0,NULL);
	NyLPC_cHttpBasicHeaderParser_finalize(&parser);
Error1:
	return NyLPC_TBool_FALSE;
}



