/*
 * NyLPC_cHttpModUtils_protected.c
 *
 *  Created on: 2013/03/05
 *      Author: nyatla
 */
#include "NyLPC_cHttpModUtils_protected.h"
#include "../NyLPC_cHttpdConnection_protected.h"

const char* NyLPC_cHttpdModUtils_getMethodPrefix(NyLPC_THttpMethodType i_method)
{
	static const char* method_prefix[3]={"GET","POST","HEAD"};
	switch(i_method)
	{
	case NyLPC_THttpMethodType_GET:
		return method_prefix[0];
	case NyLPC_THttpMethodType_POST:
		return method_prefix[1];
	case NyLPC_THttpMethodType_HEAD:
		return method_prefix[2];
	default:
		NyLPC_Abort();
	}
	return NULL;
}

NyLPC_TBool NyLPC_cHttpdModUtils_sendFixedContentBatch(NyLPC_TcHttpdConnection_t* i_connection,const NyLPC_TChar* i_content_type,const NyLPC_TChar* i_content,NyLPC_TUInt32 i_size)
{
	//HEAD or GET
	switch(NyLPC_cHttpdConnection_getMethod(i_connection))
	{
	case NyLPC_THttpMethodType_HEAD:
		//HTTP Header
		NyLPC_cHttpdConnection_sendResponseHeader2(i_connection,200,i_content_type,i_size,NULL);
		break;
	case NyLPC_THttpMethodType_GET:
		//HTTP Header
		NyLPC_cHttpdConnection_sendResponseHeader2(i_connection,200,i_content_type,i_size,NULL);
		//HTTP Body
		NyLPC_cHttpdConnection_sendResponseBody(i_connection,i_content,i_size);
		break;
	default:
		//ERROR 405
		NyLPC_cHttpdConnection_sendResponseHeader2(i_connection,405,"text/html",0,NULL);
		return NyLPC_TBool_FALSE;
	}
	return NyLPC_TBool_TRUE;
}

/**
 * 標準的なJsonヘッダを送信する。
 */
NyLPC_TBool NyLPC_cHttpdModUtils_sendJsonHeader(NyLPC_TcHttpdConnection_t* i_connection)
{
	const static char* additional_header="Access-Control-Allow-Origin:*\r\n";
	const static char* content_type="application/json";
	return NyLPC_cHttpdConnection_sendResponseHeader(i_connection,200,content_type,additional_header);
}

