# -*- coding: utf-8 -*-

require 'builder/expression_tree'
require 'builder/mint_expression_parser'

module Mint

  class InvalidExpressionError < StandardError; end

  module Builder

    class << self
      def build(expression)
        if expression.nil? || expression.empty?
          return NullExpression.new
        end
        parser.parse(expression)
      rescue
        raise InvalidExpressionError, expression
      end

      def parser
        @@parser ||= MintExpressionParser.new
      end
    end
  end
end

