# -*- coding: utf-8 -*-

module Mint

  class Expression

    def initialize(original, expression_tree) # :nodoc:
      @original        = original
      @expression_tree = expression_tree
    end

    def to_original
      @original.to_s
    end

    def to_latex
      result = @expression_tree.to_latex
      result.gsub!(/\%/, '\\')
      result
    end

    def to_maxima
      @maxima ||= @expression_tree.to_s.gsub(/\bdiv\b/, '/')
    end

    def to_ascii_math_ml
      to_latex.gsub(/\bdiv\b/, 'divide')
    end

    # Normalized expression should be cached.
    def normalize
      @expression_tree.to_s
    end
    alias to_s normalize

    def ==(other)
      return false if other.instance_of?(NullExpression)
      unless result = self.normalize == other.normalize
        result = Mint::Solver::Maxima.equal?(self.to_maxima, other.to_maxima)
      end
      result
    end

    def inspect
      "#<Mint::Expression:#{object_id} '#{self}'>"
    end
  end

  class NullExpression < Expression
    def initialize
      super '', LiteralNode.new('')
    end
    def ==(other); false end
  end
end

