# -*- coding: utf-8 -*-

module Mint::Generator

  #
  # 多次元の式のジェネレータの基底クラス
  #
  class HighOrderExpression < Base

    private

    include Utilities

    option :x, ['x']

    def generate_problem
      expression
    end

    # 判別式
    # D > 0 ならば相異なる二実数解
    # D = 0 ならば重解
    # D < 0 ならば実数解なし
    def discriminant(a, b, c)
      b**2 - 4 * a * c
    end

    def factorization
      order = create_integer(options[:order_min], options[:order_max], false)
      prefix = options[:use_coefficient] ? 'normal' : 'easy'
      case order
      when 2 then __send__("#{prefix}_factorization2")
      when 3 then __send__("#{prefix}_factorization3")
      else
        raise NotImplementedError
      end
    end

    def easy_factorization2
      alpha, beta = create_integers(2, options[:factor_min], options[:factor_max], options[:factor_minus])
      a = 1
      b = alpha + beta
      c = alpha * beta
      x = options[:x].sample
      factorization2(a, b, c, x)
    end

    def normal_factorization2
      a1, a2, alpha, beta = create_integers(4, options[:factor_min], options[:factor_max], options[:factor_minus])
      a = a1 * a2
      b = (a1 * alpha) + (a2 * beta)
      c = alpha * beta
      x = options[:x].sample
      factorization2(a, b, c, x)
    end

    def easy_factorization3
      alpha, beta, gamma = create_integers(3, options[:factor_min], options[:factor_max], options[:factor_minus])
      a = 1
      b = alpha + beta + gamma
      c = alpha * beta + beta * gamma + gamma*alpha
      d = alpha * beta * gamma
      x = options[:x].sample
      factorization3(a, b, c, d, x)
    end

    def normal_factorization3
      alpha, beta, gamma = create_integers(3, options[:factor_min], options[:factor_max], options[:factor_minus])
      _alpha, _beta, _gamma = create_integers(3, options[:factor_min], options[:factor_max], options[:factor_minus])
      a = _alpha * _beta * _gamma
      b = (_beta * _gamma * alpha) + (_alpha * beta * _gamma) + (_alpha * _beta * gamma)
      c = (alpha * beta * _gamma) + (_alpha * beta * gamma) + (alpha * _beta * gamma)
      d = alpha * beta * gamma
      x = options[:x].sample
      factorization3(a, b, c, d, x)
    end

    def old_factorization2
      begin
        a, b, c = Array.new(3){ factor(options) }
      end while a == 0 || (b == 0 && c == 0) || discriminant(a, b, c) < 0
      x = options[:x].sample
      factorization2(a, b, c, x)
    end

    def old_factorization3
      begin
        a, b, c, d = Array.new(4){ factor(options) }
        # 一階微分した式 = 0 とした方程式の判別式 < 0 ならば元の三次方程式は実数解なし
      end while a == 0 || (b == 0 && c == 0 && d == 0) || discriminant(3*a, 2*b, c) < 0
      x = options[:x].sample
      factorization3(a, b, c, d, x)
    end

    def factorization2(a, b, c, x)
      if x.instance_of?(Array)
        x, y = x.values_at(0, 1)
        return factorization2_val2(a, b, c, x, y)
      end
      factorization2_val1(a, b, c, x)
    end

    def factorization2_val1(a, b, c, x)
      e = []
      e << "%1$d%4$s^2" unless a == 0
      e << "%2$d%4$s"   unless b == 0
      e << "%3$d"       unless c == 0
      (e.join(" + ") % [a, b, c, x]).
        gsub(%r!\+ -!, '- ').gsub(/\A1#{x}|([ -])1#{x}/, '\1'+x)
    end

    def factorization2_val2(a, b, c, x, y)
      e = []
      e << "%1$d%4$s^2"   unless a == 0
      e << "%2$d%4$s%5$s" unless b == 0
      e << "%3$d%5$s^2"   unless c == 0
      (e.join(" + ") % [a, b, c, x, y]).
        gsub(%r!\+ -!, '- ').
        gsub(/\A1#{x}|([ -])1#{x}/, '\1'+x).
        gsub(/1#{y}|([ -])1#{y}/, '\1'+x+y).
        gsub(/1#{x}#{y}|([ -])1#{x}#{y}\z/, '\1'+x+y)
    end

    def factorization3(a, b, c, d, x)
      if x.instance_of?(Array)
        x, y = x.values_at(0, 1)
        return factorization3_val2(a, b, c, d, x, y)
      end
      factorization3_val1(a, b, c, d, x)
    end

    def factorization3_val1(a, b, c, d, x)
      e = []
      e << "%1$d%5$s^3" unless a == 0
      e << "%2$d%5$s^2" unless b == 0
      e << "%3$d%5$s"   unless c == 0
      e << "%4$d"       unless d == 0
      (e.join(" + ") % [a, b, c, d, x]).
        gsub(%r!\+ -!, '- ').gsub(/\A1#{x}|([ -])1#{x}/, '\1'+x)
    end

    def factorization3_val2(a, b, c, d, x, y)
      e = []
      e << "%1$d%5$s^3"     unless a == 0
      e << "%2$d%5$s^2%6$s" unless b == 0
      e << "%3$d%5$s%6$s^2" unless c == 0
      e << "%4$d%6$s^3"     unless d == 0
      (e.join(" + ") % [a, b, c, d, x, y]).
        gsub(%r!\+ -!, '- ').gsub(/\A1#{x}|([ -])1#{x}/, '\1'+x)
    end

    def expansion
      result = []
      order = create_integer(options[:order_min], options[:order_max], false)
      x = options[:x].sample
      order.times{
        coefficient = factor(options, 'coefficient')
        factor      = factor(options)
        result << single(coefficient, factor, x)
      }
      result.sort_by(&:length).reverse.join("")
    end
  end
end
