# -*- coding: utf-8 -*-

module Mint::Generator

  #
  # 因数分解の問題を生成するジェネレータ
  #
  # == オプション
  # [_order_min_]
  #   生成する方程式の次数の最小値を２もしくは３を指定します。
  # [_order_max_]
  #   生成する方程式の次数の最大値を２もしくは３を指定します。
  #   _order_min_ より小さい値を指定することは出来ません。
  # [_x_]
  #   使用可能な変数の文字を配列で指定します。
  #   文字列の代わりに配列の形で文字列のペアを
  #   指定すると、２変数を使用した式を生成します。
  # [_factor_min_]
  #   生成する式の各項の最小値を０以上の整数で指定します。
  # [_factor_max_]
  #   生成する式の各項の最大値を０以上の整数で指定します。
  #   _factor_min_ よりも小さい値を指定することは出来ません。
  # [_factor_minus_]
  #   真を指定すると、負も値を生成します。
  # [_use_coefficient_]
  #   真を指定すると、負も値を生成します。
  #
  class Factorization < HighOrderExpression

    validation /\A(?:\d+)?([a-zA-Z])\^2 [+-] (?:\d+)?\1 [+-] \d+\z/
    validation /\A(?:\d+)?([a-zA-Z])\^2 [+-] (?:\d+)?\1([a-zA-Z]) [+-] \d+\2\^2\z/
    validation /\A(?:\d+)?[a-zA-Z]\^2 [+-] (?:\d+)?[a-zA-Z]\^2\z/

    validation /\A(?:\d+)?([a-zA-Z])\^3 [+-] (?:\d+)?\1\^2 [+-] (?:\d+)?\1 [+-] \d+\z/
    validation /\A(?:\d+)?([a-zA-Z])\^3 [+-] (?:\d+)?\1\^2([a-zA-Z]) [+-] (?:\d+)?\1\2\^2 [+-] (?:\d+)?\2\^3\z/

    private

    option :order_min,       2
    option :order_max,       3
    option :factor_min,      1
    option :factor_max,      100
    option :factor_minus,    true
    option :use_coefficient, false

    def expression
      factorization
    end
  end
end

