# -*- coding: utf-8 -*-

module Mint::Generator

  #
  # 分数式の問題を生成するジェネレータ
  #
  # == オプション
  # [_term_number_]
  #   生成する式の項数を１以上の整数で指定します。
  # [_operators_]
  #   使用可能な演算子を指定します。
  #   +, -, *, div の４種類から使用したいものを配列で指定します。
  # [__numerator_term_min_]
  #   生成する分子の項数の最小値を１以上の整数で指定します。
  # [_numerator_term_max_]
  #   生成する分子の項数の最大値を１以上の整数で指定します。
  #   _numerator_term_min_ より小さい値を指定することは出来ません。
  # [_denominator_term_min_]
  #   生成する分母の項数の最小値を１以上の整数で指定します。
  # [_denominator_term_max_]
  #   生成する分母の項数の最大値を１以上の整数で指定します。
  #   _denominator_term_min_ より小さい値を指定することは出来ません。
  # [_factor_min_]
  #   生成する式の各項の最小値を０以上の整数で指定します。
  # [_factor_max_]
  #   生成する式の各項の最大値を０以上の整数で指定します。
  #   _factor_min_ よりも小さい値を指定することは出来ません。
  # [_factor_minus_]
  #   真を指定すると、負の値も生成します。
  #
  class FractionalExpressionArithmetic < Arithmetic

    DEFAULT_OPERATORS = %w[+ - * div]

    private

    include Utilities

    # TODO: I wanna set option for expression order
    option :x,                    ['x']
    option :numerator_term_min,   1
    option :numerator_term_max,   1
    option :denominator_term_min, 1
    option :denominator_term_max, 1
    option :factor_min,           1
    option :factor_max,           9
    option :factor_minus,         false

    def setup
      @x = options[:x].sample
    end

    def operand
      fraction
    end

    def fraction
      parenthesis = lambda do |value, flag|
        result = ''
        result << '(' if flag
        result << value
        result << ')' if flag
        result
      end
      np_flag = options[:numerator_term_max] > 1
      dp_flag = options[:denominator_term_max] > 1

      result = []
      result << parenthesis[numerator_part, np_flag]
      result << parenthesis[denominator_part, dp_flag]
      result.join('/')
    end

    def numerator_part
      term(:numerator)
    end

    def denominator_part
      term(:denominator)
    end

    def term(position)
      term_number = term_number(position)
      return factor(options).to_s if term_number == 0
      term_number.times.map { single(1, factor(options), @x) }.join
    end
  end
end

