# -*- coding: utf-8 -*-
require 'rational'
module Mint::Generator

  #
  # 一次関数の問題を生成するジェネレータ
  #
  # == オプション
  # [_x_minus_]
  #   真を指定すると x の値として負の値も生成します。
  # [_x_min_]
  #   x の最小値を１以上の整数で指定します。
  # [_x_max_]
  #   x の最大値を１以上の整数で指定します。
  #   _x_min_ より小さい値を指定することは出来ません。
  # [_minus_]
  #   真を指定すると傾きや切片として負の値も生成します。
  # [_numerator_min_]
  #   傾きと切片で使用する分子の最小値を１以上の整数で指定します。
  # [_numerator_max_]
  #   傾きと切片で使用する分子の最大値を１以上の整数で指定します。
  #   _numerator_min_ より小さい値を指定することは出来ません。
  # [_denominator_min_]
  #   傾きと切片で使用する分母の最小値を１以上の整数で指定します。
  # [_denominator_max_]
  #   傾きと切片で使用する分母の最大値を１以上の整数で指定します。
  #   _denominator_min_ より小さい値を指定することは出来ません。
  #
  class LinearFunctionGraph < Base

    private

    include Utilities

    option :minus,           true
    option :x_minus,         true
    option :x_min,           0
    option :x_max,           10
    option :numerator_min,   1
    option :numerator_max,   10
    option :denominator_min, 1
    option :denominator_max, 5

    def generate_problem
       a,  b = create_rational, create_rational
      x1, x2 = create_sorted_integers(2) while x1 == x2
      y1, y2 = function(a, b)[x1], function(a, b)[x2]
      { :p1 => [x1, y1], :p2 => [x2, y2], :gradient => a, :intercept => b }
    end

    def create_sorted_integers(amount)
      Array.new(amount){
        create_integer(options[:x_min], options[:x_max], options[:x_minus])
      }.sort
    end

    def function(a, b)
      @function ||= lambda{|x| a * x + b }
    end

    def create_rational
      numerator_part   = create_integer(options[:numerator_min], options[:numerator_max], options[:minus])
      denominator_part = create_integer(options[:denominator_min], options[:denominator_max], false)
      Rational(numerator_part, denominator_part)
    end
  end
end
