# -*- coding: utf-8 -*-

module Mint::Solver

  class NullExpressionError < StandardError; end

  class Base

    def solve(problem)
      unless problem.kind_of?(Mint::Expression)
        raise 'need to Mint::Expression'
      end
      raise NullExpressionError if problem.instance_of?(Mint::NullExpression)
      answer = do_solve(problem)
      Mint::Builder.build(answer)
    end

    private
    def do_solve(problem)
      solve_problem(problem)
    end

    def solve_problem(problem)
      raise 'you must overwrite this method.'
    end
  end
end

