# -*- coding: utf-8 -*-

module Mint::Solver::Maxima

  class Base < Mint::Solver::Base

    private
    def do_solve(problem)
      expression = solve_problem(problem.to_maxima)
      maxima(expression)
    end

    def maxima(expression)
      result = Mint::Solver::Maxima.exec_maxima(expression)
      result.match(/^\(%o3\)\s+(.*)$/)[1]
    end

    def query(expression)
      expression
    end

    def solve_equation(expression, x)
      query("solve(#{expression}, #{x})")
    end

    def expand(expression)
      query("expand(#{expression})")
    end

    def rootscontract(expression)
      query("rootscontract(#{expression})")
    end

    def factor(expression)
      query("factor(#{expression})")
    end

    def rectform(expression)
      query("rectform(#{expression})")
    end

    def ratsimp(expression)
      query("ratsimp(#{expression})")
    end

    def partfrac(expression)
      unless x = expression.match(/([a-zA-Z])/)
        raise 'invalid fractional expression'
      end
      query("partfrac(#{expression}, #{x[0]})")
    end
  end
end

