# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Generator

  describe Arithmetic do
    subject { Arithmetic.new }
    it_should_behave_like 'Arithmetic'
    it { expect { subject.__send__(:operand) }.to raise_error }

    context 'generate problem' do

      before(:all) do
        subject.class.
          __send__(:define_method, :generate_problem) do
            expression
          end
      end

      before { subject.should_receive(:expression) }

      it('generate') { subject.generate }
      it('generate_problem') { subject.__send__(:generate_problem) }

      it 'can set options' do
        options = { :a => 'a', :b => 'b' }
        subject.generate(options)
        subject.instance_variable_get(:@options).
          should include(:a, :b)
      end
    end

    context 'create expression' do

      (1..10).each do |i|

        it "call x #{i}" do
          set_options(:term_number => i)
          subject.should_receive(:operand).exactly(i)
          subject.should_receive(:last_operand).exactly(i)
          subject.should_receive(:last_operator).exactly(i)
          subject.__send__(:expression)
        end

        it "@ x #{i-1}" do
          set_options(:term_number => i)
          generator = subject.dup
          def generator.operand; 'operand' end
          generator.__send__(:expression).scan('@').should have(i-1).operators
        end
      end
    end
  end
end

