# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Generator

  describe Expansion do

    subject { Expansion.new }

    it_should_behave_like 'HighOrderExpression'

    before(:all) do
      @defaults = {
        :x => ['x', 'y', 'z'],
        :factor_min => 1, :factor_max => 10
      }
      @term = /\(-?(?:\d+)?([xyz]) [-+] \d+\)/
    end

    it { subject.generate(@defaults).should have(1).problem }

    context 'order 2' do
      before do
        options = {
          :order_min  => 2, :order_max  => 2,
          :factor_min => 2, :factor_max => 2,
        }
        @problems = subject.generate(@defaults.merge(options))
      end
      it{ @problems.first.scan(%r!\(.+?\)!).should have(2).terms }
      it{ @problems.first.should match(/\A#{@term}#{@term}\z/) }
      it{ @problems.first.should_not match(/[^\d]1[xyz]/) }
    end

    context 'order 3' do
      before do
        options = {
          :order_min  => 3, :order_max  => 3,
          :factor_min => 2, :factor_max => 2,
        }
        @problems = subject.generate(@defaults.merge(options))
      end
      it{ @problems.first.scan(%r!\(.+?\)!).should have(3).terms }
      it{ @problems.first.should match(/\A#{@term}#{@term}#{@term}\z/) }
      it{ @problems.first.should_not match(/[^\d]1[xyz]/) }
    end

    context 'multi variable' do
      before do
        options = {
          :order_min => 1, :order_max  => 1,
          :x => [%w[ x y ]],
        }
        subject.stub(:create_integer => 1)
        @problem = subject.generate(@defaults.merge(options)).first
      end
      it { @problem.should match(/\(x \+ y\)/) }
    end
  end
end

